/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedName
implements Comparable<QualifiedName> {
    @NotNull
    private final List<String> myComponents;

    private QualifiedName(int count) {
        this.myComponents = new ArrayList<String>(count);
    }

    public static QualifiedName fromComponents(Collection<String> components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName qName = new QualifiedName(components.size());
        qName.myComponents.addAll(components);
        return qName;
    }

    @NotNull
    public static QualifiedName fromComponents(String ... components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName result2 = new QualifiedName(components.length);
        Collections.addAll(result2.myComponents, components);
        return result2;
    }

    public QualifiedName append(String name) {
        QualifiedName result2 = new QualifiedName(this.myComponents.size() + 1);
        result2.myComponents.addAll(this.myComponents);
        result2.myComponents.add(name);
        return result2;
    }

    public QualifiedName append(QualifiedName qName) {
        QualifiedName result2 = new QualifiedName(this.myComponents.size() + qName.getComponentCount());
        result2.myComponents.addAll(this.myComponents);
        result2.myComponents.addAll(qName.getComponents());
        return result2;
    }

    @NotNull
    public QualifiedName removeLastComponent() {
        return this.removeTail(1);
    }

    @NotNull
    public QualifiedName removeTail(int count) {
        int size = this.myComponents.size();
        QualifiedName result2 = new QualifiedName(size);
        result2.myComponents.addAll(this.myComponents);
        for (int i = 0; i < count && !result2.myComponents.isEmpty(); ++i) {
            result2.myComponents.remove(result2.myComponents.size() - 1);
        }
        return result2;
    }

    @NotNull
    public QualifiedName removeHead(int count) {
        int size = this.myComponents.size();
        QualifiedName result2 = new QualifiedName(size);
        result2.myComponents.addAll(this.myComponents);
        for (int i = 0; i < count && !result2.myComponents.isEmpty(); ++i) {
            result2.myComponents.remove(0);
        }
        return result2;
    }

    @NotNull
    public List<String> getComponents() {
        return this.myComponents;
    }

    public int getComponentCount() {
        return this.myComponents.size();
    }

    public boolean matches(String ... components) {
        if (this.myComponents.size() != components.length) {
            return false;
        }
        for (int i = 0; i < this.myComponents.size(); ++i) {
            if (this.myComponents.get(i).equals(components[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPrefix(QualifiedName prefix) {
        if (this.getComponentCount() < prefix.getComponentCount()) {
            return false;
        }
        for (int i = 0; i < prefix.getComponentCount(); ++i) {
            String component = this.getComponents().get(i);
            if (component != null && component.equals(prefix.getComponents().get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(@NotNull String suffix) {
        return suffix.equals(this.getLastComponent());
    }

    public static void serialize(@Nullable QualifiedName qName, StubOutputStream dataStream) throws IOException {
        if (qName == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(qName.getComponentCount());
            for (String s : qName.myComponents) {
                dataStream.writeName(s);
            }
        }
    }

    @Nullable
    public static QualifiedName deserialize(StubInputStream dataStream) throws IOException {
        QualifiedName qName;
        int size = dataStream.readVarInt();
        if (size == 0) {
            qName = null;
        } else {
            qName = new QualifiedName(size);
            for (int i = 0; i < size; ++i) {
                qName.myComponents.add(dataStream.readNameString());
            }
        }
        return qName;
    }

    @Nullable
    public String getFirstComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(0);
    }

    @Nullable
    public String getLastComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(this.myComponents.size() - 1);
    }

    public String toString() {
        return this.join(".");
    }

    public String join(String separator) {
        return StringUtil.join(this.myComponents, (String)separator);
    }

    @NotNull
    public static QualifiedName fromDottedString(@NotNull String refName) {
        return QualifiedName.fromComponents(refName.split("\\."));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return this.myComponents.equals(that.myComponents);
    }

    public int hashCode() {
        return this.myComponents.hashCode();
    }

    public QualifiedName subQualifiedName(int fromIndex, int toIndex) {
        return QualifiedName.fromComponents(this.myComponents.subList(fromIndex, toIndex));
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        return this.toString().compareTo(other.toString());
    }

    private static void assertNoDots(@NotNull String component) {
        if (component.contains(".")) {
            throw new IllegalArgumentException("Components of QualifiedName cannot contain dots inside them, but got: " + component);
        }
    }
}

