/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReferenceSetBase<T extends PsiReference> {
    public static final char DOT_SEPARATOR = '.';
    private final NotNullLazyValue<List<T>> myReferences;
    private final PsiElement myElement;
    private final char mySeparator;

    public ReferenceSetBase(@NotNull PsiElement element) {
        this(element, ElementManipulators.getOffsetInElement(element));
    }

    public ReferenceSetBase(@NotNull PsiElement element, int offset) {
        this(ElementManipulators.getValueText(element), element, offset, '.');
    }

    public ReferenceSetBase(final String text, @NotNull PsiElement element, final int offset, char separator) {
        this.myElement = element;
        this.mySeparator = separator;
        this.myReferences = new NotNullLazyValue<List<T>>(){

            @NotNull
            protected List<T> compute() {
                return ReferenceSetBase.this.parse(text, offset);
            }
        };
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    protected List<T> parse(String str, int offset) {
        int next;
        ArrayList<T> references = new ArrayList<T>();
        int current = -1;
        int index2 = 0;
        do {
            TextRange range;
            if ((range = new TextRange(offset + current + 1, offset + ((next = this.findNextSeparator(str, current)) >= 0 ? next : str.length()))).isEmpty() && Character.isWhitespace(this.mySeparator)) continue;
            references.addAll(this.createReferences(range, index2++));
        } while ((current = next) >= 0);
        return references;
    }

    protected int findNextSeparator(String str, int current) {
        int next = str.indexOf(this.mySeparator, current + 1);
        return next;
    }

    @Nullable
    protected T createReference(TextRange range, int index2) {
        return null;
    }

    protected List<T> createReferences(TextRange range, int index2) {
        T reference = this.createReference(range, index2);
        return reference == null ? Collections.emptyList() : Collections.singletonList(reference);
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public List<T> getReferences() {
        return (List)this.myReferences.getValue();
    }

    @NotNull
    public PsiReference[] getPsiReferences() {
        return this.getReferences().toArray(PsiReference.EMPTY_ARRAY);
    }

    public T getReference(int index2) {
        return (T)((PsiReference)this.getReferences().get(index2));
    }

    @Nullable
    public T getLastReference() {
        return this.getReferences().isEmpty() ? null : (T)this.getReference(this.getReferences().size() - 1);
    }
}

