/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefactoringElementListenerComposite
implements RefactoringElementListener,
UndoRefactoringElementListener {
    private final List<RefactoringElementListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public void addListener(RefactoringElementListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void elementMoved(@NotNull PsiElement newElement) {
        for (RefactoringElementListener myListener : this.myListeners) {
            myListener.elementMoved(newElement);
        }
    }

    @Override
    public void elementRenamed(@NotNull PsiElement newElement) {
        for (RefactoringElementListener myListener : this.myListeners) {
            myListener.elementRenamed(newElement);
        }
    }

    @Override
    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
        for (RefactoringElementListener listener : this.myListeners) {
            if (!(listener instanceof UndoRefactoringElementListener)) continue;
            ((UndoRefactoringElementListener)((Object)listener)).undoElementMovedOrRenamed(newElement, oldQualifiedName);
        }
    }
}

