/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.semantic.SemElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SemKey<T extends SemElement> {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final String myDebugName;
    @NotNull
    private final SemKey<? super T>[] mySupers;
    private final List<SemKey> myInheritors = ContainerUtil.createEmptyCOWList();
    private final int myUniqueId;

    @SafeVarargs
    private SemKey(String debugName, SemKey<? super T> ... supers) {
        this.myDebugName = debugName;
        this.mySupers = supers;
        this.myUniqueId = counter.getAndIncrement();
        this.myInheritors.add(this);
        this.registerInheritor(this);
    }

    private void registerInheritor(SemKey eachParent) {
        for (SemKey<? super T> superKey : eachParent.mySupers) {
            superKey.myInheritors.add(this);
            this.registerInheritor(superKey);
        }
    }

    @NotNull
    public SemKey<? super T>[] getSupers() {
        return this.mySupers;
    }

    public List<SemKey> getInheritors() {
        return this.myInheritors;
    }

    public boolean isKindOf(SemKey<?> another) {
        if (another == this) {
            return true;
        }
        for (SemKey<T> semKey : this.mySupers) {
            if (!semKey.isKindOf(another)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.myDebugName;
    }

    @SafeVarargs
    public static <T extends SemElement> SemKey<T> createKey(String debugName, SemKey<? super T> ... supers) {
        return new SemKey<T>(debugName, supers);
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    @SafeVarargs
    public final <K extends T> SemKey<K> subKey(@NonNls String debugName, SemKey<? super T> ... otherSupers) {
        if (otherSupers.length == 0) {
            return new SemKey<T>(debugName, this);
        }
        return new SemKey<T>(debugName, (SemKey[])ArrayUtil.append((Object[])otherSupers, (Object)this));
    }
}

