/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskContext
extends UserDataHolderBase {
    @Nullable
    private final Object mySessionId;
    @Nullable
    private final RunConfiguration myRunConfiguration;
    private final boolean myAutoRun;
    private final MultiMap<String, String> myGeneratedFiles;
    private volatile boolean myCollectGeneratedFiles;

    public ProjectTaskContext() {
        this(null, null, false);
    }

    public ProjectTaskContext(boolean autoRun) {
        this(null, null, autoRun);
    }

    public ProjectTaskContext(@Nullable Object sessionId) {
        this(sessionId, null, false);
    }

    public ProjectTaskContext(@Nullable Object sessionId, @Nullable RunConfiguration runConfiguration) {
        this(sessionId, runConfiguration, false);
    }

    public ProjectTaskContext(@Nullable Object sessionId, @Nullable RunConfiguration runConfiguration, boolean autoRun) {
        this.mySessionId = sessionId;
        this.myRunConfiguration = runConfiguration;
        this.myAutoRun = autoRun;
        this.myGeneratedFiles = MultiMap.createConcurrentSet();
    }

    @Nullable
    public Object getSessionId() {
        return this.mySessionId;
    }

    @Nullable
    public RunConfiguration getRunConfiguration() {
        return this.myRunConfiguration;
    }

    public boolean isAutoRun() {
        return this.myAutoRun;
    }

    @ApiStatus.Experimental
    public void enableCollectionOfGeneratedFiles() {
        this.myCollectGeneratedFiles = true;
    }

    @NotNull
    @ApiStatus.Experimental
    public Collection<String> getGeneratedFilesRoots() {
        return this.myGeneratedFiles.keySet();
    }

    @NotNull
    @ApiStatus.Experimental
    public Collection<String> getGeneratedFilesRelativePaths(@NotNull String root) {
        return this.myGeneratedFiles.get((Object)root);
    }

    @ApiStatus.Experimental
    public void fileGenerated(@NotNull String root, @NotNull String relativePath) {
        if (this.myCollectGeneratedFiles) {
            this.myGeneratedFiles.putValue((Object)root, (Object)relativePath);
        }
    }

    public <T> ProjectTaskContext withUserData(@NotNull Key<T> key, @Nullable T value) {
        this.putUserData(key, value);
        return this;
    }
}

