/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ProjectTaskResult {
    private final boolean myAborted;
    private final int myErrors;
    private final int myWarnings;
    private final Map<ProjectTask, ProjectTaskState> myTasksState;

    public ProjectTaskResult(boolean aborted, int errors, int warnings) {
        this.myAborted = aborted;
        this.myErrors = errors;
        this.myWarnings = warnings;
        this.myTasksState = Collections.emptyMap();
    }

    public ProjectTaskResult(boolean aborted, int errors, int warnings, @NotNull Map<ProjectTask, ProjectTaskState> tasksState) {
        this.myAborted = aborted;
        this.myErrors = errors;
        this.myWarnings = warnings;
        this.myTasksState = ContainerUtil.unmodifiableOrEmptyMap(tasksState);
    }

    public boolean isAborted() {
        return this.myAborted;
    }

    public int getErrors() {
        return this.myErrors;
    }

    public int getWarnings() {
        return this.myWarnings;
    }

    @NotNull
    public Map<ProjectTask, ProjectTaskState> getTasksState() {
        return this.myTasksState;
    }

    public boolean anyMatch(@NotNull BiPredicate<ProjectTask, ProjectTaskState> predicate) {
        return this.myTasksState.entrySet().stream().anyMatch((? super T entry) -> predicate.test((ProjectTask)entry.getKey(), (ProjectTaskState)entry.getValue()));
    }

    @NotNull
    public List<ProjectTask> getTasks(@NotNull BiPredicate<ProjectTask, ProjectTaskState> predicate) {
        return this.myTasksState.entrySet().stream().filter(entry -> predicate.test((ProjectTask)entry.getKey(), (ProjectTaskState)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @NotNull
    public List<Module> getAffectedModules(@NotNull Predicate<ProjectTaskState> predicate) {
        return this.myTasksState.entrySet().stream().filter(entry -> entry.getKey() instanceof ModuleBuildTask).filter(entry -> predicate.test((ProjectTaskState)entry.getValue())).map(entry -> ((ModuleBuildTask)entry.getKey()).getModule()).collect(Collectors.toList());
    }

    @NotNull
    public <T extends ProjectModelBuildableElement> List<T> getBuildableElements(@NotNull Class<T> buildableClass, @NotNull Predicate<ProjectTaskState> predicate) {
        return this.myTasksState.entrySet().stream().filter(entry -> entry.getKey() instanceof ProjectModelBuildTask).filter(entry -> buildableClass.isInstance(((ProjectModelBuildTask)entry.getKey()).getBuildableElement())).filter(entry -> predicate.test((ProjectTaskState)entry.getValue())).map(entry -> (ProjectModelBuildableElement)buildableClass.cast(((ProjectModelBuildTask)entry.getKey()).getBuildableElement())).collect(Collectors.toList());
    }
}

