/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CheckBoxWithColorChooser
extends JPanel {
    private Color myColor;
    private final JCheckBox myCheckbox;

    public CheckBoxWithColorChooser(String text, boolean selected, Color color) {
        this.setLayout(new BoxLayout(this, 0));
        this.myColor = color;
        this.myCheckbox = new JCheckBox(text, selected);
        this.add(this.myCheckbox);
        this.add(new MyColorButton());
    }

    public CheckBoxWithColorChooser(String text, boolean selected) {
        this(text, selected, Color.WHITE);
    }

    public CheckBoxWithColorChooser(String text) {
        this(text, false);
    }

    public void setMnemonic(char c) {
        this.myCheckbox.setMnemonic(c);
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public void setSelected(boolean selected) {
        this.myCheckbox.setSelected(selected);
    }

    public boolean isSelected() {
        return this.myCheckbox.isSelected();
    }

    private class MyColorButton
    extends JButton {
        MyColorButton() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setDefaultCapable(false);
            this.setFocusable(false);
            if (SystemInfo.isMac) {
                this.putClientProperty("JButton.buttonType", "square");
            }
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    Color color;
                    if (CheckBoxWithColorChooser.this.myCheckbox.isSelected() && (color = ColorChooser.chooseColor(CheckBoxWithColorChooser.this.myCheckbox, "Chose color", CheckBoxWithColorChooser.this.myColor)) != null) {
                        CheckBoxWithColorChooser.this.myColor = color;
                    }
                    return true;
                }
            }.installOn((Component)this);
        }

        @Override
        public void paint(Graphics g) {
            Color color = g.getColor();
            g.setColor(CheckBoxWithColorChooser.this.myColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(color);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(12, 12);
        }
    }
}

