/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.EditableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionListModel<T>
extends AbstractListModel<T>
implements EditableModel {
    private final List<T> myItems;

    public CollectionListModel(@NotNull Collection<? extends T> items) {
        this.myItems = new ArrayList<T>(items);
    }

    public CollectionListModel(@NotNull List<T> items, boolean useListAsIs) {
        this.myItems = items;
    }

    public CollectionListModel(@NotNull List<? extends T> items) {
        this.myItems = new ArrayList<T>(items);
    }

    @SafeVarargs
    public CollectionListModel(T ... items) {
        this.myItems = ContainerUtilRt.newArrayList((Object[])items);
    }

    @NotNull
    protected final List<T> getInternalList() {
        return this.myItems;
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public T getElementAt(int index2) {
        return this.myItems.get(index2);
    }

    public void add(T element) {
        int i = this.myItems.size();
        this.myItems.add(element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(int i, T element) {
        this.myItems.add(i, element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(@NotNull List<? extends T> elements) {
        this.addAll(this.myItems.size(), elements);
    }

    public void addAll(int index2, @NotNull List<? extends T> elements) {
        if (elements.isEmpty()) {
            return;
        }
        this.myItems.addAll(index2, elements);
        this.fireIntervalAdded(this, index2, index2 + elements.size() - 1);
    }

    public void remove(@NotNull T element) {
        int index2 = this.getElementIndex(element);
        if (index2 != -1) {
            this.remove(index2);
        }
    }

    public void setElementAt(@NotNull T item, int index2) {
        this.itemReplaced(this.myItems.set(index2, item), item);
        this.fireContentsChanged(this, index2, index2);
    }

    protected void itemReplaced(@NotNull T existingItem, @Nullable T newItem) {
    }

    public void remove(int index2) {
        T item = this.myItems.remove(index2);
        if (item != null) {
            this.itemReplaced(item, null);
        }
        this.fireIntervalRemoved(this, index2, index2);
    }

    public void removeAll() {
        int size = this.myItems.size();
        if (size > 0) {
            this.myItems.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    public void contentsChanged(@NotNull T element) {
        int i = this.myItems.indexOf(element);
        this.fireContentsChanged(this, i, i);
    }

    public void allContentsChanged() {
        this.fireContentsChanged(this, 0, this.myItems.size() - 1);
    }

    public void sort(Comparator<? super T> comparator) {
        Collections.sort(this.myItems, comparator);
    }

    @NotNull
    public List<T> getItems() {
        return Collections.unmodifiableList(this.myItems);
    }

    public void replaceAll(@NotNull List<? extends T> elements) {
        this.removeAll();
        this.add(elements);
    }

    public void addRow() {
    }

    public void removeRow(int index2) {
        this.remove(index2);
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        Collections.swap(this.myItems, oldIndex, newIndex);
        this.fireContentsChanged(this, oldIndex, oldIndex);
        this.fireContentsChanged(this, newIndex, newIndex);
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    @NonNls
    public String toString() {
        return this.getClass().getName() + " (" + this.getSize() + " elements)";
    }

    public List<T> toList() {
        return new ArrayList<T>(this.myItems);
    }

    public int getElementIndex(T item) {
        return this.myItems.indexOf(item);
    }

    public boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    public boolean contains(T item) {
        return this.getElementIndex(item) >= 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must be <= toIndex");
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            this.itemReplaced(this.myItems.remove(i), null);
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }
}

