/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColoredListCellRenderer<T>
extends SimpleColoredComponent
implements ListCellRenderer<T> {
    @Nullable
    private final JComboBox myComboBox;
    protected boolean mySelected;
    protected Color myForeground;
    protected Color mySelectionForeground;

    public ColoredListCellRenderer() {
        this(null);
    }

    public ColoredListCellRenderer(@Nullable JComboBox comboBox) {
        this.myComboBox = comboBox;
        this.setFocusBorderAroundIcon(true);
        this.getIpad().right = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUI.scale((int)UIUtil.getListCellHPadding());
        this.getIpad().left = this.getIpad().right;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index2, boolean selected, boolean hasFocus) {
        this.clear();
        if (this.myComboBox != null) {
            this.setEnabled(this.myComboBox.isEnabled());
        }
        this.setFont(list.getFont());
        this.mySelected = selected;
        this.myForeground = this.isEnabled() ? list.getForeground() : UIManager.getColor("Label.disabledForeground");
        this.mySelectionForeground = list.getSelectionForeground();
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.setBackground(selected ? list.getSelectionBackground() : list.getBackground());
        } else {
            this.setBackground(selected ? list.getSelectionBackground() : null);
        }
        this.setPaintFocusBorder(hasFocus);
        this.customizeCellRenderer(list, value, index2, selected, hasFocus);
        return this;
    }

    @Override
    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (this.mySelected) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), this.mySelectionForeground), isMainText);
        } else if (attributes.getFgColor() == null) {
            super.append(fragment, attributes.derive(-1, this.myForeground, null, null), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    @Override
    void revalidateAndRepaint() {
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Font oldFont = this.getFont();
        if (oldFont == null) {
            this.setFont(UIUtil.getListFont());
        }
        Dimension result2 = super.getPreferredSize();
        if (oldFont == null) {
            this.setFont(null);
        }
        return result2;
    }

    protected abstract void customizeCellRenderer(@NotNull JList<? extends T> var1, T var2, int var3, boolean var4, boolean var5);

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }
}

