/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleColoredRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class ColoredTableCellRenderer
extends SimpleColoredRenderer
implements TableCellRenderer {
    private static final Logger LOG = Logger.getInstance(ColoredTableCellRenderer.class);

    @Override
    public final Component getTableCellRendererComponent(JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        try {
            this.rendererComponentInner(table, value, isSelected, hasFocus, row, col);
        }
        catch (Exception e) {
            try {
                LOG.error((Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    private void rendererComponentInner(JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.clear();
        this.setPaintFocusBorder(hasFocus && table.getCellSelectionEnabled());
        this.acquireState(table, isSelected, hasFocus, row, col);
        this.getCellState().updateRenderer(this);
        this.customizeCellRenderer(table, value, isSelected, hasFocus, row, col);
    }

    protected abstract void customizeCellRenderer(JTable var1, @Nullable Object var2, boolean var3, boolean var4, int var5, int var6);
}

