/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ui.components.JBLabel;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextHelpLabel
extends JBLabel {
    private final HelpTooltip tooltip;

    public ContextHelpLabel(String label, String description) {
        super(label);
        this.tooltip = new HelpTooltip().setDescription(description);
        this.initTooltip();
    }

    private ContextHelpLabel(@NotNull HelpTooltip tooltip) {
        super(AllIcons.General.ContextHelp);
        this.tooltip = tooltip;
        this.initTooltip();
    }

    private void initTooltip() {
        this.tooltip.setNeverHideOnTimeout(true).setLocation(HelpTooltip.Alignment.HELP_BUTTON);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tooltip.installOn(this);
    }

    @Override
    public void removeNotify() {
        HelpTooltip.dispose(this);
        super.removeNotify();
    }

    @NotNull
    public static ContextHelpLabel create(@NotNull String description) {
        return new ContextHelpLabel(new HelpTooltip().setDescription(description));
    }

    @NotNull
    public static ContextHelpLabel create(@NotNull String title, @NotNull String description) {
        return new ContextHelpLabel(new HelpTooltip().setDescription(description).setTitle(title));
    }

    @NotNull
    public static ContextHelpLabel createWithLink(@Nullable String title, @NotNull String description, @NotNull String linkText, @NotNull Runnable linkAction) {
        return new ContextHelpLabel(new HelpTooltip().setDescription(description).setTitle(title).setLink(linkText, linkAction));
    }

    @Override
    public void setPreferredSize(Dimension size) {
    }
}

