/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;

public class EnumComboBoxModel<E extends Enum<E>>
extends AbstractListModel<E>
implements ComboBoxModel<E> {
    private final List<E> myList;
    private E mySelected;

    public EnumComboBoxModel(@NotNull Class<E> en) {
        this.myList = new ArrayList<E>(this.createEnumSet(en));
        this.mySelected = (Enum)this.myList.get(0);
    }

    @NotNull
    protected EnumSet<E> createEnumSet(@NotNull Class<E> en) {
        return EnumSet.allOf(en);
    }

    @Override
    public int getSize() {
        return this.myList.size();
    }

    @Override
    public E getElementAt(int index2) {
        return (E)((Enum)this.myList.get(index2));
    }

    @Override
    public void setSelectedItem(Object item) {
        Enum e = (Enum)item;
        this.setSelectedItem((E)e);
    }

    @Override
    public void setSelectedItem(E item) {
        this.mySelected = item;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public E getSelectedItem() {
        return this.mySelected;
    }
}

