/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ExpandedItemListCellRendererWrapper<T>
implements ListCellRenderer<T> {
    @NotNull
    private final ListCellRenderer<? super T> myWrappee;
    @NotNull
    private final ExpandableItemsHandler<Integer> myHandler;

    public ExpandedItemListCellRendererWrapper(@NotNull ListCellRenderer<? super T> wrappee, @NotNull ExpandableItemsHandler<Integer> handler) {
        this.myWrappee = wrappee;
        this.myHandler = handler;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index2, boolean isSelected, boolean cellHasFocus) {
        GraphicsUtil.setAntialiasingType(list, (Object)AntialiasingType.getAAHintForSwingComponent());
        Component result2 = this.myWrappee.getListCellRendererComponent(list, UIUtil.htmlInjectionGuard(value), index2, isSelected, cellHasFocus);
        if (!this.myHandler.getExpandedItems().contains(index2)) {
            return result2;
        }
        Rectangle bounds = result2.getBounds();
        ExpandedItemRendererComponentWrapper wrapper = ExpandedItemRendererComponentWrapper.wrap(result2);
        if (UIUtil.isClientPropertyTrue(list, ExpandableItemsHandler.EXPANDED_RENDERER) && UIUtil.isClientPropertyTrue((Object)result2, ExpandableItemsHandler.USE_RENDERER_BOUNDS)) {
            wrapper.setBounds(bounds);
            UIUtil.putClientProperty((JComponent)wrapper, ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)true);
        }
        wrapper.owner = list;
        return wrapper;
    }

    public String toString() {
        return "ExpandedItemListCellRendererWrapper[" + this.getWrappee().getClass().getName() + "]";
    }

    @NotNull
    public ListCellRenderer getWrappee() {
        return this.myWrappee;
    }
}

