/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HighlightedRegion;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightableComponent
extends JComponent
implements Accessible {
    protected String myText = "";
    protected Icon myIcon;
    protected int myIconTextGap = 4;
    protected ArrayList<HighlightedRegion> myHighlightedRegions;
    protected boolean myIsSelected;
    protected boolean myHasFocus;
    protected boolean myPaintUnfocusedSelection = false;
    private boolean myDoNotHighlight = false;
    private Color myEnforcedBackground = null;

    public HighlightableComponent() {
        this.setText("");
        this.setOpaque(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        UISettings.setupComponentAntialiasing(this);
    }

    public void setText(@Nullable String text) {
        String oldAccessibleName = null;
        if (this.accessibleContext != null) {
            oldAccessibleName = this.accessibleContext.getAccessibleName();
        }
        if (text == null) {
            text = "";
        }
        this.myText = text;
        this.myHighlightedRegions = new ArrayList(4);
        if (this.accessibleContext != null && !StringUtil.equals((CharSequence)this.accessibleContext.getAccessibleName(), (CharSequence)oldAccessibleName)) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldAccessibleName, this.accessibleContext.getAccessibleName());
        }
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
        this.invalidate();
        this.repaint();
    }

    public void addHighlighter(int startOffset, int endOffset, TextAttributes attributes) {
        this.addHighlighter(0, startOffset, endOffset, attributes);
    }

    private void addHighlighter(int startIndex, int startOffset, int endOffset, TextAttributes attributes) {
        if (startOffset < 0) {
            startOffset = 0;
        }
        if (endOffset > this.myText.length()) {
            endOffset = this.myText.length();
        }
        if (startOffset >= endOffset) {
            return;
        }
        if (this.myHighlightedRegions.size() == 0) {
            this.myHighlightedRegions.add(new HighlightedRegion(startOffset, endOffset, attributes));
        } else {
            for (int i = startIndex; i < this.myHighlightedRegions.size(); ++i) {
                HighlightedRegion hRegion = this.myHighlightedRegions.get(i);
                if (startOffset < hRegion.startOffset && endOffset <= hRegion.startOffset) {
                    this.myHighlightedRegions.add(i, new HighlightedRegion(startOffset, endOffset, attributes));
                    break;
                }
                if (startOffset >= hRegion.endOffset && i == this.myHighlightedRegions.size() - 1) {
                    this.myHighlightedRegions.add(new HighlightedRegion(startOffset, endOffset, attributes));
                    break;
                }
                if (startOffset < hRegion.startOffset && endOffset > hRegion.startOffset) {
                    if (endOffset < hRegion.endOffset) {
                        this.myHighlightedRegions.add(i, new HighlightedRegion(startOffset, hRegion.startOffset, attributes));
                        this.myHighlightedRegions.add(i + 1, new HighlightedRegion(hRegion.startOffset, endOffset, TextAttributes.merge(hRegion.textAttributes, attributes)));
                        hRegion.startOffset = endOffset;
                        break;
                    }
                    if (endOffset == hRegion.endOffset) {
                        this.myHighlightedRegions.remove(hRegion);
                        this.myHighlightedRegions.add(i, new HighlightedRegion(startOffset, hRegion.startOffset, attributes));
                        this.myHighlightedRegions.add(i + 1, new HighlightedRegion(hRegion.startOffset, endOffset, TextAttributes.merge(hRegion.textAttributes, attributes)));
                        break;
                    }
                    if (endOffset > hRegion.endOffset) {
                        this.myHighlightedRegions.remove(hRegion);
                        this.myHighlightedRegions.add(i, new HighlightedRegion(startOffset, hRegion.startOffset, attributes));
                        this.myHighlightedRegions.add(i + 1, new HighlightedRegion(hRegion.startOffset, hRegion.endOffset, TextAttributes.merge(hRegion.textAttributes, attributes)));
                        if (i < this.myHighlightedRegions.size() - 1) {
                            this.addHighlighter(i + 1, hRegion.endOffset, endOffset, attributes);
                            break;
                        }
                        this.myHighlightedRegions.add(i + 2, new HighlightedRegion(hRegion.endOffset, endOffset, attributes));
                        break;
                    }
                }
                if (startOffset < hRegion.startOffset || startOffset >= hRegion.endOffset) continue;
                int oldEndOffset = hRegion.endOffset;
                hRegion.endOffset = startOffset;
                if (endOffset < oldEndOffset) {
                    this.myHighlightedRegions.add(i + 1, new HighlightedRegion(startOffset, endOffset, TextAttributes.merge(hRegion.textAttributes, attributes)));
                    this.myHighlightedRegions.add(i + 2, new HighlightedRegion(endOffset, oldEndOffset, hRegion.textAttributes));
                    if (startOffset != hRegion.startOffset) break;
                    this.myHighlightedRegions.remove(hRegion);
                    break;
                }
                if (endOffset == oldEndOffset) {
                    this.myHighlightedRegions.add(i + 1, new HighlightedRegion(startOffset, oldEndOffset, TextAttributes.merge(hRegion.textAttributes, attributes)));
                    if (startOffset != hRegion.startOffset) break;
                    this.myHighlightedRegions.remove(hRegion);
                    break;
                }
                if (endOffset <= oldEndOffset) continue;
                this.myHighlightedRegions.add(i + 1, new HighlightedRegion(startOffset, oldEndOffset, TextAttributes.merge(hRegion.textAttributes, attributes)));
                if (i < this.myHighlightedRegions.size() - 1) {
                    this.addHighlighter(i + 1, oldEndOffset, endOffset, attributes);
                } else {
                    this.myHighlightedRegions.add(i + 2, new HighlightedRegion(hRegion.endOffset, endOffset, attributes));
                }
                if (startOffset != hRegion.startOffset) break;
                this.myHighlightedRegions.remove(hRegion);
                break;
            }
        }
    }

    public void setIconTextGap(int gap) {
        this.myIconTextGap = Math.max(gap, 2);
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    protected void enforceBackgroundOutsideText(Color bg) {
        this.myEnforcedBackground = bg;
    }

    protected void setDoNotHighlight(boolean b) {
        this.myDoNotHighlight = b;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int textOffset;
        boolean paintHighlightsForeground;
        boolean paintHighlightsBackground;
        Color fgColor;
        Color bgColor;
        if (this.myIsSelected && (this.myHasFocus || this.myPaintUnfocusedSelection)) {
            bgColor = UIUtil.getTreeSelectionBackground();
            fgColor = UIUtil.getTreeSelectionForeground();
            paintHighlightsBackground = false;
            paintHighlightsForeground = false;
        } else {
            bgColor = this.myEnforcedBackground == null ? UIUtil.getTreeBackground() : this.myEnforcedBackground;
            fgColor = this.getForeground();
            paintHighlightsBackground = this.isOpaque();
            paintHighlightsForeground = true;
        }
        if (this.myDoNotHighlight) {
            paintHighlightsForeground = false;
        }
        int offset = textOffset = this.getTextOffset();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, Math.max(0, textOffset - 2), this.getHeight());
            g.setColor(bgColor);
            g.fillRect(Math.max(0, textOffset - 2), 0, this.getWidth(), this.getHeight());
        }
        if (this.myIcon != null) {
            this.myIcon.paintIcon(this, g, 0, (this.getHeight() - this.myIcon.getIconHeight()) / 2);
        }
        this.applyRenderingHints(g);
        FontMetrics defFontMetrics = this.getFontMetrics(this.getFont());
        if (this.myText == null) {
            this.myText = "";
        }
        int yOffset = (this.getHeight() - defFontMetrics.getMaxAscent() - defFontMetrics.getMaxDescent()) / 2 + defFontMetrics.getMaxAscent() - 1;
        if (this.myHighlightedRegions.size() == 0) {
            g.setColor(fgColor);
            g.drawString(this.myText, textOffset, yOffset);
        } else {
            int endIndex = 0;
            for (HighlightedRegion hRegion : this.myHighlightedRegions) {
                String text = this.myText.substring(endIndex, hRegion.startOffset);
                endIndex = hRegion.endOffset;
                if (text.length() != 0) {
                    g.setColor(fgColor);
                    g.setFont(defFontMetrics.getFont());
                    g.drawString(text, offset, yOffset);
                    offset += defFontMetrics.stringWidth(text);
                }
                Font regFont = this.getFont().deriveFont(hRegion.textAttributes.getFontType());
                FontMetrics fontMetrics = this.getFontMetrics(regFont);
                text = this.myText.substring(hRegion.startOffset, hRegion.endOffset);
                if (hRegion.textAttributes.getBackgroundColor() != null && paintHighlightsBackground) {
                    g.setColor(hRegion.textAttributes.getBackgroundColor());
                    g.fillRect(offset, 0, fontMetrics.stringWidth(text), fontMetrics.getHeight() + fontMetrics.getLeading());
                }
                if (hRegion.textAttributes.getForegroundColor() != null && paintHighlightsForeground) {
                    g.setColor(hRegion.textAttributes.getForegroundColor());
                } else {
                    g.setColor(fgColor);
                }
                g.setFont(fontMetrics.getFont());
                g.drawString(text, offset, yOffset);
                if (hRegion.textAttributes.getEffectType() != null && hRegion.textAttributes.getEffectColor() != null) {
                    g.setColor(hRegion.textAttributes.getEffectColor());
                    int y = yOffset + 2;
                    UIUtil.drawLine((Graphics)g, (int)offset, (int)y, (int)(offset + fontMetrics.stringWidth(text) - 1), (int)y);
                }
                if (hRegion.textAttributes.getEffectColor() != null && hRegion.textAttributes.getEffectType() == EffectType.BOXED) {
                    g.setColor(hRegion.textAttributes.getEffectColor());
                    g.drawRect(offset, 0, fontMetrics.stringWidth(text) - 1, fontMetrics.getHeight() + fontMetrics.getLeading() - 1);
                }
                offset += fontMetrics.stringWidth(text);
            }
            String text = this.myText.substring(endIndex);
            if (text.length() != 0) {
                g.setColor(fgColor);
                g.setFont(defFontMetrics.getFont());
                g.drawString(text, offset, yOffset);
            }
        }
        if (this.myIsSelected) {
            g.setColor(UIUtil.getTreeSelectionBorderColor());
            UIUtil.drawDottedRectangle((Graphics)g, (int)(textOffset - 2), (int)0, (int)(this.getWidth() - 1), (int)(this.getHeight() - 1));
        }
        super.paintComponent(g);
    }

    protected void applyRenderingHints(Graphics g) {
        UISettings.setupAntialiasing(g);
    }

    protected int getTextOffset() {
        if (this.myIcon == null) {
            return 2;
        }
        return this.myIcon.getIconWidth() + this.myIconTextGap;
    }

    @Nullable
    public HighlightedRegion findRegionByX(int x) {
        FontMetrics defFontMetrics = this.getFontMetrics(this.getFont());
        int width = this.getTextOffset();
        if (width > x) {
            return null;
        }
        if (this.myText.length() != 0 && this.myHighlightedRegions.size() != 0) {
            int endIndex = 0;
            for (HighlightedRegion hRegion : this.myHighlightedRegions) {
                endIndex = hRegion.endOffset;
                if ((width += defFontMetrics.stringWidth(this.myText.substring(endIndex, hRegion.startOffset))) > x) {
                    return null;
                }
                String text = this.getRegionText(hRegion);
                Font regFont = this.getFont().deriveFont(hRegion.textAttributes.getFontType());
                FontMetrics fontMetrics = this.getFontMetrics(regFont);
                if ((width += fontMetrics.stringWidth(text)) <= x) continue;
                return hRegion;
            }
        }
        return null;
    }

    @NotNull
    public Map<String, Rectangle> getHighlightedRegionsBoundsMap() {
        HashMap<String, Rectangle> map = new HashMap<String, Rectangle>();
        FontMetrics defFontMetrics = this.getFontMetrics(this.getFont());
        int pivot = this.getTextOffset();
        if (this.myText.length() != 0 && this.myHighlightedRegions.size() != 0) {
            int endIndex = 0;
            for (HighlightedRegion hRegion : this.myHighlightedRegions) {
                int start = pivot += defFontMetrics.stringWidth(this.myText.substring(endIndex, hRegion.startOffset));
                endIndex = hRegion.endOffset;
                String text = this.getRegionText(hRegion);
                Font regFont = this.getFont().deriveFont(hRegion.textAttributes.getFontType());
                FontMetrics fontMetrics = this.getFontMetrics(regFont);
                int end = pivot += fontMetrics.stringWidth(text);
                map.put(text, new Rectangle(this.getBounds().x + start, this.getBounds().y, end - start, this.getBounds().height));
            }
        }
        return map;
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics defFontMetrics = this.getFontMetrics(this.getFont());
        int width = this.getTextOffset();
        if (this.myText.length() != 0) {
            if (this.myHighlightedRegions.size() == 0) {
                width += defFontMetrics.stringWidth(this.myText);
            } else {
                int endIndex = 0;
                for (HighlightedRegion hRegion : this.myHighlightedRegions) {
                    width += defFontMetrics.stringWidth(this.myText.substring(endIndex, hRegion.startOffset));
                    endIndex = hRegion.endOffset;
                    String text = this.getRegionText(hRegion);
                    Font regFont = this.getFont().deriveFont(hRegion.textAttributes.getFontType());
                    FontMetrics fontMetrics = this.getFontMetrics(regFont);
                    width += fontMetrics.stringWidth(text);
                }
                width += defFontMetrics.stringWidth(this.myText.substring(endIndex));
            }
        }
        int height = defFontMetrics.getHeight() + defFontMetrics.getLeading();
        if (this.myIcon != null) {
            height = Math.max(this.myIcon.getIconHeight() + defFontMetrics.getLeading(), height);
        }
        return new Dimension(width + 2, height);
    }

    public String getRegionText(HighlightedRegion hRegion) {
        String text = hRegion.endOffset > this.myText.length() ? (hRegion.startOffset < this.myText.length() ? this.myText.substring(hRegion.startOffset) : "") : this.myText.substring(hRegion.startOffset, hRegion.endOffset);
        return text;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHighlightable();
        }
        return this.accessibleContext;
    }

    protected class AccessibleHighlightable
    extends JComponent.AccessibleJComponent {
        protected AccessibleHighlightable() {
            super(HighlightableComponent.this);
        }

        @Override
        public String getAccessibleName() {
            return HighlightableComponent.this.myText;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

