/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.HighlightableComponent;
import com.intellij.ui.HighlightedRegion;
import com.intellij.ui.HighlightedText;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperlinkLabel
extends HighlightableComponent {
    private static final TextAttributes BOLD_ATTRIBUTES = new TextAttributes((Color)new JBColor(() -> {
        Color foreground1 = UIUtil.getLabelTextForeground();
        return foreground1 == null ? UIUtil.getLabelForeground() : foreground1;
    }), null, null, null, 1);
    private static final Logger LOG = Logger.getInstance((String)HyperlinkLabel.class.getName());
    private UIUtil.FontSize myFontSize;
    private HighlightedText myHighlightedText;
    private final List<HyperlinkListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myUseIconAsLink;
    private final TextAttributes myAnchorAttributes;
    private HyperlinkListener myHyperlinkListener;
    private boolean myMouseHover;
    private boolean myMousePressed;

    public HyperlinkLabel() {
        this("");
    }

    public HyperlinkLabel(String text) {
        this(text, UIUtil.getLabelBackground());
    }

    public HyperlinkLabel(String text, Color background) {
        this(text, PlatformColors.BLUE, background, PlatformColors.BLUE);
    }

    public HyperlinkLabel(String text, Color textForegroundColor, Color textBackgroundColor, Color textEffectColor) {
        this.myAnchorAttributes = UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() ? new CustomTextAttributes(textBackgroundColor) : new TextAttributes(textForegroundColor, textBackgroundColor, textEffectColor, EffectType.LINE_UNDERSCORE, 0);
        this.enforceBackgroundOutsideText(textBackgroundColor);
        this.setHyperlinkText(text);
        this.enableEvents(48L);
        this.setOpaque(false);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                HyperlinkLabel.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                HyperlinkLabel.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                    e.consume();
                    HyperlinkLabel.this.doClick();
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.adjustSize();
    }

    public void setFontSize(@Nullable UIUtil.FontSize fontSize) {
        this.myFontSize = fontSize;
    }

    public void setHyperlinkText(String text) {
        this.setHyperlinkText("", text, "");
    }

    public void setHyperlinkText(String beforeLinkText, String linkText, String afterLinkText) {
        this.myUseIconAsLink = beforeLinkText.isEmpty();
        this.prepareText(beforeLinkText, linkText, afterLinkText);
    }

    public void setUseIconAsLink(boolean useIconAsLink) {
        this.myUseIconAsLink = useIconAsLink;
    }

    protected void adjustSize() {
        Dimension preferredSize = this.getPreferredSize();
        this.setMinimumSize(preferredSize);
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent event) {
        if (event.getModifiers() == 0 && event.getKeyCode() == 32) {
            event.consume();
            this.fireHyperlinkEvent();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 504 && this.isOnLink(e.getX())) {
            this.myMouseHover = true;
            this.repaint();
        } else if (e.getID() == 505) {
            this.setCursor(Cursor.getDefaultCursor());
            this.myMouseHover = false;
            this.myMousePressed = false;
            this.repaint();
        } else if (UIUtil.isActionClick((MouseEvent)e, (int)501) && this.isOnLink(e.getX())) {
            this.fireHyperlinkEvent();
            this.myMousePressed = true;
            this.repaint();
        } else if (e.getID() == 502) {
            this.myMousePressed = false;
            this.repaint();
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            boolean onLink = this.isOnLink(e.getX());
            boolean needRepaint = this.myMouseHover != onLink;
            this.myMouseHover = onLink;
            this.setCursor(this.myMouseHover ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
            if (needRepaint) {
                this.repaint();
            }
        }
        super.processMouseMotionEvent(e);
    }

    private boolean isOnLink(int x) {
        if (this.myUseIconAsLink && this.myIcon != null && x < this.myIcon.getIconWidth()) {
            return true;
        }
        HighlightedRegion region = this.findRegionByX(x);
        return region != null && region.textAttributes == this.myAnchorAttributes;
    }

    private void prepareText(String beforeLinkText, String linkText, String afterLinkText) {
        this.applyFont();
        this.myHighlightedText = new HighlightedText();
        this.myHighlightedText.appendText(beforeLinkText, null);
        this.myHighlightedText.appendText(linkText, this.myAnchorAttributes);
        this.myHighlightedText.appendText(afterLinkText, null);
        this.myHighlightedText.applyToComponent(this);
        this.updateOnTextChange();
    }

    @Override
    public void setText(@Nullable String text) {
        this.applyFont();
        this.myUseIconAsLink = false;
        super.setText(text);
        this.updateOnTextChange();
    }

    public void setHyperlinkTarget(@Nullable String url) {
        if (this.myHyperlinkListener != null) {
            this.removeHyperlinkListener(this.myHyperlinkListener);
        }
        if (url != null) {
            this.myHyperlinkListener = e -> BrowserUtil.browse(url);
            this.addHyperlinkListener(this.myHyperlinkListener);
        }
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.add(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.myListeners.remove(listener);
    }

    @NotNull
    public String getText() {
        return this.myHighlightedText.getText();
    }

    protected void fireHyperlinkEvent() {
        HyperlinkEvent e = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, null);
        for (HyperlinkListener listener : this.myListeners) {
            listener.hyperlinkUpdate(e);
        }
    }

    public void doClick() {
        this.fireHyperlinkEvent();
    }

    public void setHtmlText(String text) {
        ParserDelegator parse = new ParserDelegator();
        final HighlightedText highlightedText = new HighlightedText();
        try {
            ((HTMLEditorKit.Parser)parse).parse(new StringReader(text), new HTMLEditorKit.ParserCallback(){
                private TextAttributes currentAttributes;

                @Override
                public void handleText(char[] data, int pos) {
                    highlightedText.appendText(data, this.currentAttributes);
                }

                @Override
                public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                    if (t == HTML.Tag.B) {
                        this.currentAttributes = BOLD_ATTRIBUTES;
                    } else if (t == HTML.Tag.A) {
                        this.currentAttributes = HyperlinkLabel.this.myAnchorAttributes;
                    }
                }

                @Override
                public void handleEndTag(HTML.Tag t, int pos) {
                    this.currentAttributes = null;
                }
            }, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        highlightedText.applyToComponent(this);
        this.updateOnTextChange();
    }

    private void updateOnTextChange() {
        JComponent parent = (JComponent)this.getParent();
        if (parent != null) {
            parent.revalidate();
            parent.repaint();
        }
        this.adjustSize();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.applyFont();
    }

    private void applyFont() {
        this.setFont(this.myFontSize == null ? UIUtil.getLabelFont() : UIUtil.getLabelFont((UIUtil.FontSize)this.myFontSize));
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.myIsSelected = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == this;
        super.paintComponent(g);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHyperlinkLabel();
        }
        return this.accessibleContext;
    }

    private class CustomTextAttributes
    extends TextAttributes {
        private CustomTextAttributes(Color textBackgroundColor) {
            super(null, textBackgroundColor, null, null, 0);
        }

        @Override
        public Color getForegroundColor() {
            return !HyperlinkLabel.this.isEnabled() ? UIManager.getColor("Label.disabledForeground") : (HyperlinkLabel.this.myMousePressed ? JBUI.CurrentTheme.Link.linkPressedColor() : (HyperlinkLabel.this.myMouseHover ? JBUI.CurrentTheme.Link.linkHoverColor() : JBUI.CurrentTheme.Link.linkColor()));
        }

        @Override
        public Color getEffectColor() {
            return this.getForegroundColor();
        }

        @Override
        public EffectType getEffectType() {
            return !HyperlinkLabel.this.isEnabled() || HyperlinkLabel.this.myMouseHover || HyperlinkLabel.this.myMousePressed ? EffectType.LINE_UNDERSCORE : null;
        }

        @Override
        public void setForegroundColor(Color color) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEffectColor(Color color) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEffectType(EffectType effectType) {
            throw new UnsupportedOperationException();
        }
    }

    protected class AccessibleHyperlinkLabel
    extends HighlightableComponent.AccessibleHighlightable
    implements AccessibleAction {
        protected AccessibleHyperlinkLabel() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.HYPERLINK;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i == 0) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0) {
                HyperlinkLabel.this.doClick();
                return true;
            }
            return false;
        }
    }

    public static class Croppable
    extends HyperlinkLabel {
        @Override
        protected void adjustSize() {
        }
    }
}

