/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class JBIntSpinner
extends JSpinner {
    public JBIntSpinner(UINumericRange range) {
        this(range.initial, range.min, range.max);
    }

    public JBIntSpinner(int value, int minValue, int maxValue) {
        this(value, minValue, maxValue, 1);
    }

    public JBIntSpinner(int value, int minValue, int maxValue, int stepSize) {
        this.setModel(new SpinnerNumberModel(value, minValue, maxValue, stepSize));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor((JSpinner)this, "#");
        JFormattedTextField textField = editor.getTextField();
        textField.setColumns(Math.max(4, textField.getColumns()));
        if (UIUtil.isUnderWin10LookAndFeel()) {
            textField.setHorizontalAlignment(2);
        }
        this.setEditor(editor);
        MyListener listener = new MyListener();
        this.addMouseWheelListener(listener);
        textField.addFocusListener(listener);
        textField.addMouseListener(listener);
        this.addMouseListener(listener);
    }

    @Override
    public void setEditor(JComponent editor) {
        if (!(editor instanceof JSpinner.NumberEditor)) {
            throw new IllegalArgumentException("JBSpinner allows NumberEditor only");
        }
        super.setEditor(editor);
    }

    @NotNull
    private JTextField getTextField() {
        return ((JSpinner.NumberEditor)this.getEditor()).getTextField();
    }

    private SpinnerNumberModel getNumberModel() {
        return (SpinnerNumberModel)super.getModel();
    }

    public void setMin(int value) {
        this.getNumberModel().setMinimum(Integer.valueOf(value));
    }

    public void setMax(int value) {
        this.getNumberModel().setMaximum(Integer.valueOf(value));
    }

    public int getMin() {
        return ((Number)((Object)this.getNumberModel().getMinimum())).intValue();
    }

    public int getMax() {
        return ((Number)((Object)this.getNumberModel().getMaximum())).intValue();
    }

    public void setNumber(int value) {
        this.setValue(Math.max(this.getMin(), Math.min(this.getMax(), value)));
    }

    public int getNumber() {
        return this.getNumberModel().getNumber().intValue();
    }

    private static Number calculateNewValue(SpinnerNumberModel model, int steps) {
        int newValue = ((Number)model.getValue()).intValue() + model.getStepSize().intValue() * steps;
        Comparable<?> minimum = model.getMinimum();
        Comparable<?> maximum = model.getMaximum();
        if (minimum instanceof Number && minimum.compareTo(newValue) > 0) {
            return (Number)((Object)minimum);
        }
        if (maximum instanceof Number && maximum.compareTo(newValue) < 0) {
            return (Number)((Object)maximum);
        }
        return newValue;
    }

    private class MyListener
    extends MouseAdapter
    implements FocusListener {
        private boolean mySelect = true;

        private MyListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTextField textField;
            this.mySelect = false;
            Component component = e.getComponent();
            if (component == JBIntSpinner.this && (textField = JBIntSpinner.this.getTextField()).isEnabled()) {
                MouseEvent event = SwingUtilities.convertMouseEvent(component, e, textField);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(textField, true));
                SwingUtilities.invokeLater(() -> textField.dispatchEvent(event));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!this.mySelect) {
                this.mySelect = true;
                return;
            }
            SwingUtilities.invokeLater(() -> JBIntSpinner.this.getTextField().selectAll());
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.mySelect = true;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getUnitsToScroll() == 0) {
                return;
            }
            JTextField field = JBIntSpinner.this.getTextField();
            SpinnerNumberModel model = JBIntSpinner.this.getNumberModel();
            if (field.hasFocus() && JBIntSpinner.this.isEnabled()) {
                model.setValue(JBIntSpinner.calculateNewValue(model, e.getUnitsToScroll()));
            }
        }
    }
}

