/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListUtil {
    public static final String SELECTED_BY_MOUSE_EVENT = "byMouseEvent";
    private static final ListModelExtension DEFAULT_MODEL = new ListModelExtension<Object, DefaultListModel<Object>>(){

        @Override
        public Object get(DefaultListModel<Object> model, int index2) {
            return model.get(index2);
        }

        @Override
        public void set(DefaultListModel<Object> model, int index2, Object item) {
            model.set(index2, item);
        }

        @Override
        public void remove(DefaultListModel<Object> model, int index2) {
            model.remove(index2);
        }

        @Override
        public void removeAll(DefaultListModel<Object> model) {
            model.removeAllElements();
        }

        @Override
        public void addAll(DefaultListModel<Object> model, List<Object> item) {
            model.addElement(item);
        }
    };
    private static final ListModelExtension COLLECTION_MODEL = new ListModelExtension<Object, CollectionListModel<Object>>(){

        @Override
        public Object get(CollectionListModel<Object> model, int index2) {
            return model.getElementAt(index2);
        }

        @Override
        public void set(CollectionListModel<Object> model, int index2, Object item) {
            model.setElementAt(item, index2);
        }

        @Override
        public void remove(CollectionListModel<Object> model, int index2) {
            model.remove(index2);
        }

        @Override
        public void removeAll(CollectionListModel<Object> model) {
            model.removeAll();
        }

        @Override
        public void addAll(CollectionListModel<Object> model, List<Object> items) {
            model.addAll(model.getSize(), items);
        }
    };
    private static final ListModelExtension SORTED_MODEL = new ListModelExtension<Object, SortedListModel<Object>>(){

        @Override
        public Object get(SortedListModel<Object> model, int index2) {
            return model.get(index2);
        }

        @Override
        public void set(SortedListModel<Object> model, int index2, Object item) {
            model.remove(index2);
            model.add(item);
        }

        @Override
        public void remove(SortedListModel<Object> model, int index2) {
            model.remove(index2);
        }

        @Override
        public void removeAll(SortedListModel<Object> model) {
            model.clear();
        }

        @Override
        public void addAll(SortedListModel<Object> model, List<Object> items) {
            model.addAll(items);
        }
    };
    private static final ListModelExtension FILTERED_MODEL = new ListModelExtension<Object, FilteringListModel<Object>>(){

        @Override
        public Object get(FilteringListModel<Object> model, int index2) {
            return model.getElementAt(index2);
        }

        @Override
        public void set(FilteringListModel<Object> model, int index2, Object item) {
            ListUtil.getExtension(model.getOriginalModel()).set(model.getOriginalModel(), index2, item);
        }

        @Override
        public void remove(FilteringListModel<Object> model, int index2) {
            model.remove(index2);
        }

        @Override
        public void removeAll(FilteringListModel<Object> model) {
            model.replaceAll(Collections.emptyList());
        }

        @Override
        public void addAll(FilteringListModel<Object> model, List<Object> items) {
            model.addAll(items);
        }
    };

    public static <T> MouseMotionListener installAutoSelectOnMouseMove(final @NotNull JList<T> list) {
        MouseMotionAdapter listener = new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !(focusOwner instanceof JRootPane)) {
                    Point point = e.getPoint();
                    int index2 = list.locationToIndex(point);
                    list.putClientProperty(ListUtil.SELECTED_BY_MOUSE_EVENT, Boolean.TRUE);
                    list.setSelectedIndex(index2);
                    list.putClientProperty(ListUtil.SELECTED_BY_MOUSE_EVENT, Boolean.FALSE);
                } else {
                    this.myIsEngaged = true;
                }
            }
        };
        list.addMouseMotionListener(listener);
        return listener;
    }

    @NotNull
    public static <T> List<T> removeSelectedItems(@NotNull JList<T> list) {
        return ListUtil.removeSelectedItems(list, null);
    }

    @NotNull
    public static <T> List<T> removeIndices(@NotNull JList<T> list, int[] indices) {
        return ListUtil.removeIndices(list, indices, null);
    }

    @NotNull
    public static <T> List<T> removeSelectedItems(@NotNull JList<T> list, @Nullable Condition<? super T> condition) {
        int[] indices = list.getSelectedIndices();
        return ListUtil.removeIndices(list, indices, condition);
    }

    public static <T> void removeItem(@NotNull ListModel<T> model, int index2) {
        ListUtil.getExtension(model).remove(model, index2);
    }

    public static <T> void removeAllItems(@NotNull ListModel<T> model) {
        ListUtil.getExtension(model).removeAll(model);
    }

    public static <T> void addAllItems(@NotNull ListModel<T> model, @NotNull List<T> items) {
        ListUtil.getExtension(model).addAll(model, items);
    }

    private static <T> List<T> removeIndices(@NotNull JList<T> list, @NotNull int[] indices, @Nullable Condition<? super T> condition) {
        if (indices.length == 0) {
            return new ArrayList(0);
        }
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        int firstSelectedIndex = indices[0];
        ArrayList<T> removedItems = new ArrayList<T>();
        int deletedCount = 0;
        for (int idx1 : indices) {
            int index2 = idx1 - deletedCount;
            if (index2 < 0 || index2 >= model.getSize()) continue;
            T obj = extension.get(model, index2);
            if (condition != null && !condition.value(obj)) continue;
            removedItems.add(obj);
            extension.remove(model, index2);
            ++deletedCount;
        }
        if (model.getSize() == 0) {
            list.clearSelection();
        } else if (list.getSelectedValue() == null) {
            if (firstSelectedIndex >= model.getSize()) {
                list.setSelectedIndex(model.getSize() - 1);
            } else {
                list.setSelectedIndex(firstSelectedIndex);
            }
        }
        return removedItems;
    }

    public static <T> boolean canRemoveSelectedItems(@NotNull JList<T> list) {
        return ListUtil.canRemoveSelectedItems(list, null);
    }

    public static <T> boolean canRemoveSelectedItems(@NotNull JList<T> list, @Nullable Condition<? super T> condition) {
        int[] indices = list.getSelectedIndices();
        if (indices.length == 0) {
            return false;
        }
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        for (int index2 : indices) {
            if (index2 < 0 || index2 >= model.getSize()) continue;
            T obj = extension.get(model, index2);
            if (condition != null && !condition.value(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> int moveSelectedItemsUp(@NotNull JList<T> list) {
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        int[] indices = list.getSelectedIndices();
        if (!ListUtil.canMoveSelectedItemsUp(list)) {
            return 0;
        }
        for (int index2 : indices) {
            T temp = extension.get(model, index2);
            extension.set(model, index2, extension.get(model, index2 - 1));
            extension.set(model, index2 - 1, temp);
            list.removeSelectionInterval(index2, index2);
            list.addSelectionInterval(index2 - 1, index2 - 1);
        }
        Rectangle cellBounds = list.getCellBounds(indices[0] - 1, indices[indices.length - 1] - 1);
        if (cellBounds != null) {
            list.scrollRectToVisible(cellBounds);
        }
        return indices.length;
    }

    public static <T> boolean canMoveSelectedItemsUp(@NotNull JList<T> list) {
        int[] indices = list.getSelectedIndices();
        return indices.length > 0 && indices[0] > 0;
    }

    public static <T> int moveSelectedItemsDown(@NotNull JList<T> list) {
        ListModel<T> model = list.getModel();
        ListModelExtension<T, ListModel<T>> extension = ListUtil.getExtension(model);
        int[] indices = list.getSelectedIndices();
        if (!ListUtil.canMoveSelectedItemsDown(list)) {
            return 0;
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            int index2 = indices[i];
            T temp = extension.get(model, index2);
            extension.set(model, index2, extension.get(model, index2 + 1));
            extension.set(model, index2 + 1, temp);
            list.removeSelectionInterval(index2, index2);
            list.addSelectionInterval(index2 + 1, index2 + 1);
        }
        Rectangle cellBounds = list.getCellBounds(indices[0] + 1, indices[indices.length - 1] + 1);
        if (cellBounds != null) {
            list.scrollRectToVisible(cellBounds);
        }
        return indices.length;
    }

    public static <T> boolean isPointOnSelection(@NotNull JList<T> list, int x, int y) {
        int row = list.locationToIndex(new Point(x, y));
        if (row < 0) {
            return false;
        }
        return list.isSelectedIndex(row);
    }

    @Nullable
    public static <E> Component getDeepestRendererChildComponentAt(@NotNull JList<E> list, @NotNull Point point) {
        int idx = list.locationToIndex(point);
        if (idx < 0) {
            return null;
        }
        Rectangle cellBounds = list.getCellBounds(idx, idx);
        if (!cellBounds.contains(point)) {
            return null;
        }
        E value = list.getModel().getElementAt(idx);
        if (value == null) {
            return null;
        }
        Component rendererComponent = list.getCellRenderer().getListCellRendererComponent(list, value, idx, true, true);
        rendererComponent.setBounds(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
        UIUtil.layoutRecursively((Component)rendererComponent);
        int rendererRelativeX = point.x - cellBounds.x;
        int rendererRelativeY = point.y - cellBounds.y;
        return UIUtil.getDeepestComponentAt((Component)rendererComponent, (int)rendererRelativeX, (int)rendererRelativeY);
    }

    public static <T> boolean canMoveSelectedItemsDown(@NotNull JList<T> list) {
        ListModel<T> model = list.getModel();
        int[] indices = list.getSelectedIndices();
        return indices.length > 0 && indices[indices.length - 1] < model.getSize() - 1;
    }

    public static <T> Updatable addMoveUpListener(@NotNull JButton button, final @NotNull JList<T> list) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsUp(list);
                list.requestFocusInWindow();
            }
        });
        return ListUtil.disableWhenNoSelection(button, list);
    }

    public static <T> Updatable addMoveDownListener(@NotNull JButton button, final @NotNull JList<T> list) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsDown(list);
                list.requestFocusInWindow();
            }
        });
        return ListUtil.disableWhenNoSelection(button, list);
    }

    public static <T> Updatable addRemoveListener(@NotNull JButton button, @NotNull JList<T> list) {
        return ListUtil.addRemoveListener(button, list, null);
    }

    public static <T> Updatable addRemoveListener(@NotNull JButton button, final @NotNull JList<T> list, final @Nullable RemoveNotification<T> notification) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List items = ListUtil.removeSelectedItems(list);
                if (notification != null) {
                    notification.itemsRemoved(items);
                }
                list.requestFocusInWindow();
            }
        });
        class MyListSelectionListener
        extends Updatable
        implements ListSelectionListener {
            final /* synthetic */ JList val$list;

            MyListSelectionListener(JButton jButton) {
                this.val$list = jButton;
                super(button);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.setButtonEnabled(ListUtil.canRemoveSelectedItems(this.val$list));
            }

            @Override
            protected void update() {
                this.valueChanged(null);
            }
        }
        MyListSelectionListener listener = new MyListSelectionListener(button, list);
        list.getSelectionModel().addListSelectionListener(listener);
        listener.update();
        return listener;
    }

    public static <T> Updatable disableWhenNoSelection(@NotNull JButton button, @NotNull JList<T> list) {
        class MyListSelectionListener
        extends Updatable
        implements ListSelectionListener {
            final /* synthetic */ JList val$list;

            MyListSelectionListener(JButton jButton) {
                this.val$list = jButton;
                super(button);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.setButtonEnabled(this.val$list.getSelectedIndex() != -1);
            }

            @Override
            public void update() {
                this.valueChanged(null);
            }
        }
        MyListSelectionListener listener = new MyListSelectionListener(button, list);
        list.getSelectionModel().addListSelectionListener(listener);
        listener.update();
        return listener;
    }

    @NotNull
    private static <T, ModelType extends ListModel<T>> ListModelExtension<T, ModelType> getExtension(@NotNull ModelType model) {
        if (model instanceof DefaultListModel) {
            return DEFAULT_MODEL;
        }
        if (model instanceof SortedListModel) {
            return SORTED_MODEL;
        }
        if (model instanceof FilteringListModel) {
            return FILTERED_MODEL;
        }
        if (model instanceof CollectionListModel) {
            return COLLECTION_MODEL;
        }
        throw new AssertionError((Object)("Unknown model class: " + model.getClass().getName()));
    }

    private static interface ListModelExtension<T, ModelType extends ListModel<T>> {
        public T get(ModelType var1, int var2);

        public void set(ModelType var1, int var2, T var3);

        public void remove(ModelType var1, int var2);

        public void removeAll(ModelType var1);

        public void addAll(ModelType var1, List<T> var2);
    }

    public static interface RemoveNotification<ItemType> {
        public void itemsRemoved(List<ItemType> var1);
    }

    public static abstract class Updatable {
        private final JButton myButton;
        private boolean myEnabled = true;

        public Updatable(JButton button) {
            this.myButton = button;
        }

        public void enable(boolean enable) {
            this.myEnabled = enable;
            this.update();
        }

        protected void setButtonEnabled(boolean enabled) {
            this.myButton.setEnabled(enabled && this.myEnabled);
        }

        protected abstract void update();
    }
}

