/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class OffsetIcon
extends JBUI.CachingScalableJBIcon<OffsetIcon> {
    private int myWidth;
    private int myHeight;
    private final int myOffset;
    private final Icon myIcon;
    private Icon myScaledIcon;
    private int myScaledOffset;

    public OffsetIcon(@NotNull Icon icon) {
        this(20, icon);
    }

    public OffsetIcon(int offset, @NotNull Icon icon) {
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myOffset = offset;
        this.myIcon = icon;
        this.updateSize();
    }

    private OffsetIcon(@NotNull OffsetIcon icon) {
        super((JBUI.CachingScalableJBIcon)icon);
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myOffset = icon.myOffset;
        this.myIcon = icon.myIcon;
        this.myScaledIcon = null;
        this.myScaledOffset = icon.myScaledOffset;
    }

    @NotNull
    public OffsetIcon copy() {
        return new OffsetIcon(this);
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    public int hashCode() {
        return this.myOffset + this.myIcon.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OffsetIcon) {
            OffsetIcon icon = (OffsetIcon)((Object)obj);
            return icon.myOffset == this.myOffset && Objects.equals(icon.myIcon, this.myIcon);
        }
        return false;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getScaleContext().update();
        if (this.myScaledIcon == null) {
            float scale = this.getScale();
            this.myScaledIcon = scale == 1.0f ? this.myIcon : IconUtil.scale(this.myIcon, null, scale);
        }
        this.myScaledIcon.paintIcon(c, g, this.myScaledOffset + x, y);
    }

    public int getIconWidth() {
        this.getScaleContext().update();
        return (int)Math.ceil(this.scaleVal(this.myWidth, JBUI.ScaleType.OBJ_SCALE)) + this.myScaledOffset;
    }

    public int getIconHeight() {
        this.getScaleContext().update();
        return (int)Math.ceil(this.scaleVal(this.myHeight, JBUI.ScaleType.OBJ_SCALE));
    }

    private void updateSize() {
        this.myWidth = this.myIcon.getIconWidth();
        this.myHeight = this.myIcon.getIconHeight();
        this.myScaledOffset = (int)Math.ceil(this.scaleVal(this.myOffset));
    }

    public String toString() {
        return "OffsetIcon: offset=" + this.myOffset + "; icon=" + this.myIcon;
    }
}

