/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class OptionalChooserComponent<T>
implements CheckBoxListListener,
ComponentWithEmptyText {
    private JPanel myContentPane;
    private CheckBoxList myList;
    private DefaultListModel myListModel;
    private List<Pair<T, Boolean>> myInitialList;
    private ArrayList<Pair<T, Boolean>> myWorkingList;

    public OptionalChooserComponent(@NotNull List<Pair<T, Boolean>> list) {
        this.$$$setupUI$$$();
        this.setInitialList(list);
        this.myWorkingList = new ArrayList<Pair<T, Boolean>>(this.myInitialList);
        this.reset();
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        return this.myList.getEmptyText();
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public void checkBoxSelectionChanged(int index2, boolean value) {
        Pair<T, Boolean> pair = this.myWorkingList.remove(index2);
        this.myWorkingList.add(index2, Pair.create((Object)pair.first, (Object)value));
    }

    private void createUIComponents() {
        this.myList = new CheckBoxList(this);
        this.myList.setBorder(null);
        this.myListModel = (DefaultListModel)this.myList.getModel();
    }

    public void reset() {
        this.myWorkingList = new ArrayList<Pair<T, Boolean>>(this.myInitialList);
        this.refresh();
    }

    protected abstract JCheckBox createCheckBox(T var1, boolean var2);

    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    public void setSelectedIndex(int index2) {
        this.myList.setSelectedIndex(index2);
    }

    public boolean removeAt(int index2) {
        this.getCurrentModel().remove(index2);
        this.refresh();
        if (index2 < this.getCurrentModel().size()) {
            this.setSelectedIndex(index2);
            return true;
        }
        if (index2 > 0) {
            this.setSelectedIndex(index2 - 1);
            return true;
        }
        return false;
    }

    public boolean removeSelected() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != -1) {
            return this.removeAt(selectedIndex);
        }
        return false;
    }

    public boolean isModified() {
        return !this.myWorkingList.equals(this.myInitialList);
    }

    public void setInitialList(@NotNull List<Pair<T, Boolean>> list) {
        this.myInitialList = list;
    }

    public ArrayList<Pair<T, Boolean>> getCurrentModel() {
        return this.myWorkingList;
    }

    public void apply() {
        this.myInitialList.clear();
        this.myInitialList.addAll(this.myWorkingList);
    }

    public void refresh() {
        this.myListModel.clear();
        for (Pair<T, Boolean> pair : this.myWorkingList) {
            this.myListModel.addElement(this.createCheckBox(pair.first, (Boolean)pair.second));
        }
    }

    public CheckBoxList getList() {
        return this.myList;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        CheckBoxList checkBoxList = this.myList;
        checkBoxList.setSelectionMode(0);
        jBScrollPane.setViewportView(checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

