/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.UIBundle;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReorderableListController<T> {
    private final JList myList;
    private static final Icon REMOVE_ICON = IconUtil.getRemoveIcon();

    protected ReorderableListController(JList list) {
        this.myList = list;
    }

    public JList getList() {
        return this.myList;
    }

    public RemoveActionDescription addRemoveAction(String actionName) {
        RemoveActionDescription description = new RemoveActionDescription(actionName);
        this.addActionDescription(description);
        return description;
    }

    protected abstract void addActionDescription(ActionDescription var1);

    public AddActionDescription addAddAction(String actionName, Factory<? extends T> creator, boolean createShortcut) {
        AddActionDescription description = new AddActionDescription(actionName, creator, createShortcut);
        this.addActionDescription(description);
        return description;
    }

    public AddMultipleActionDescription addAddMultipleAction(String actionName, Factory<? extends Collection<T>> creator, boolean createShortcut) {
        AddMultipleActionDescription description = new AddMultipleActionDescription(actionName, creator, createShortcut);
        this.addActionDescription(description);
        return description;
    }

    public void addMoveUpAction() {
        this.addAction(new AnAction(UIBundle.message((String)"move.up.action.name", (Object[])new Object[0]), null, IconUtil.getMoveUpIcon()){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ListUtil.moveSelectedItemsUp(ReorderableListController.this.myList);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(ListUtil.canMoveSelectedItemsUp(ReorderableListController.this.myList));
            }
        });
    }

    public void addMoveDownAction() {
        this.addAction(new AnAction(UIBundle.message((String)"move.down.action.name", (Object[])new Object[0]), null, AllIcons.Actions.MoveDown){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                ListUtil.moveSelectedItemsDown(ReorderableListController.this.myList);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(ListUtil.canMoveSelectedItemsDown(ReorderableListController.this.myList));
            }
        });
    }

    public void addAction(AnAction action) {
        this.addActionDescription(new FixedActionDescription(action));
    }

    private void handleNewElement(T element) {
        ListModel listModel = this.myList.getModel();
        if (listModel instanceof SortedListModel) {
            ((SortedListModel)listModel).add(element);
        } else {
            ((DefaultListModel)listModel).addElement(element);
        }
        this.myList.clearSelection();
        ScrollingUtil.selectItem(this.myList, element);
    }

    public static <T> ReorderableListController<T> create(final JList list, final DefaultActionGroup actionGroup) {
        return new ReorderableListController<T>(list){

            @Override
            protected void addActionDescription(ActionDescription description) {
                actionGroup.add(description.createAction(list));
            }
        };
    }

    private static class FixedActionDescription
    extends ActionDescription {
        private final AnAction myAction;

        FixedActionDescription(AnAction action) {
            this.myAction = action;
        }

        @Override
        public AnAction createAction(JComponent component) {
            return this.myAction;
        }
    }

    public class AddMultipleActionDescription
    extends AddActionDescriptionBase<Collection<T>> {
        public AddMultipleActionDescription(String actionDescription, Factory<? extends Collection<T>> addHandler, boolean createShortcut) {
            super(actionDescription, addHandler, createShortcut);
        }

        @Override
        protected Collection<T> addInternal(Collection<T> t) {
            if (t != null) {
                for (Object element : t) {
                    ReorderableListController.this.handleNewElement(element);
                }
            }
            return t;
        }
    }

    public class AddActionDescription
    extends AddActionDescriptionBase<T> {
        public AddActionDescription(String actionDescription, Factory<? extends T> addHandler, boolean createShortcut) {
            super(actionDescription, addHandler, createShortcut);
        }

        @Override
        protected T addInternal(T t) {
            if (t != null) {
                ReorderableListController.this.handleNewElement(t);
            }
            return t;
        }
    }

    public static abstract class AddActionDescriptionBase<V>
    extends CustomActionDescription<V> {
        private final String myActionDescription;
        private final Factory<? extends V> myAddHandler;
        private final boolean myCreateShortcut;
        private Icon myIcon = IconUtil.getAddIcon();

        public AddActionDescriptionBase(String actionDescription, Factory<? extends V> addHandler, boolean createShortcut) {
            this.myActionDescription = actionDescription;
            this.myAddHandler = addHandler;
            this.myCreateShortcut = createShortcut;
        }

        @Override
        public CustomActionDescription.BaseAction createAction(JComponent component) {
            ActionBehaviour behaviour = new ActionBehaviour<V>(){

                @Override
                public V performAction(@NotNull AnActionEvent e) {
                    return this.addInternal(myAddHandler.create());
                }

                @Override
                public void updateAction(@NotNull AnActionEvent e) {
                }
            };
            CustomActionDescription.BaseAction action = this.createAction(behaviour);
            if (this.myCreateShortcut) {
                action.registerCustomShortcutSet(CommonShortcuts.INSERT, component);
            }
            return action;
        }

        @Nullable
        protected abstract V addInternal(V var1);

        @Override
        public Icon getActionIcon() {
            return this.myIcon;
        }

        @Override
        public String getActionName() {
            return this.myActionDescription;
        }

        public void setIcon(Icon icon) {
            this.myIcon = icon;
        }
    }

    public class RemoveActionDescription
    extends CustomActionDescription<List<T>> {
        private final String myActionName;
        private Condition<? super List<T>> myConfirmation;
        private Condition<? super T> myEnableCondition;

        public RemoveActionDescription(String actionName) {
            this.myActionName = actionName;
        }

        @Override
        public CustomActionDescription.BaseAction createAction(JComponent component) {
            ActionBehaviour behaviour = new ActionBehaviour<List<T>>(){

                @Override
                public List<T> performAction(@NotNull AnActionEvent e) {
                    if (RemoveActionDescription.this.myConfirmation != null && !RemoveActionDescription.this.myConfirmation.value(Arrays.asList(ReorderableListController.this.myList.getSelectedValues()))) {
                        return Collections.emptyList();
                    }
                    return ListUtil.removeSelectedItems(ReorderableListController.this.myList, RemoveActionDescription.this.myEnableCondition);
                }

                @Override
                public void updateAction(@NotNull AnActionEvent e) {
                    e.getPresentation().setEnabled(ListUtil.canRemoveSelectedItems(ReorderableListController.this.myList, RemoveActionDescription.this.myEnableCondition));
                }
            };
            CustomActionDescription.BaseAction action = this.createAction(behaviour);
            action.registerCustomShortcutSet(CommonShortcuts.getDelete(), component);
            return action;
        }

        @Override
        protected Icon getActionIcon() {
            return REMOVE_ICON;
        }

        @Override
        protected String getActionName() {
            return this.myActionName;
        }

        public void setConfirmation(Condition<? super List<T>> confirmation) {
            this.myConfirmation = confirmation;
        }

        public void setEnableCondition(Condition<? super T> enableCondition) {
            this.myEnableCondition = enableCondition;
        }

        public JList getList() {
            return ReorderableListController.this.myList;
        }
    }

    static interface ActionBehaviour<T> {
        public T performAction(@NotNull AnActionEvent var1);

        public void updateAction(@NotNull AnActionEvent var1);
    }

    public static abstract class CustomActionDescription<V>
    extends ActionDescription {
        private final ArrayList<ActionNotification<V>> myPostHandlers = new ArrayList(1);
        private boolean myShowText = false;

        public void addPostHandler(ActionNotification<V> runnable) {
            this.myPostHandlers.add(runnable);
        }

        protected void runPostHandlers(V change) {
            for (ActionNotification<V> runnable : this.myPostHandlers) {
                runnable.afterActionPerformed(change);
            }
        }

        @Override
        public abstract BaseAction createAction(JComponent var1);

        BaseAction createAction(ActionBehaviour behaviour) {
            return this.myShowText ? new ActionWithText(this, this.getActionName(), null, this.getActionIcon(), behaviour) : new BaseAction(this, this.getActionName(), null, this.getActionIcon(), behaviour);
        }

        protected abstract Icon getActionIcon();

        protected abstract String getActionName();

        public void setShowText(boolean showText) {
            this.myShowText = showText;
        }

        private static class ActionWithText<V>
        extends BaseAction {
            ActionWithText(CustomActionDescription<? super V> customActionDescription, String text, String description, Icon icon, ActionBehaviour<? extends V> behaviour) {
                super(customActionDescription, text, description, icon, behaviour);
            }

            @Override
            public boolean displayTextInToolbar() {
                return true;
            }
        }

        protected static class BaseAction<V>
        extends DumbAwareAction {
            private final ActionBehaviour<? extends V> myBehaviour;
            private final CustomActionDescription<? super V> myCustomActionDescription;

            public BaseAction(CustomActionDescription<? super V> customActionDescription, String text, String description, Icon icon, ActionBehaviour<? extends V> behaviour) {
                super(text, description, icon);
                this.myBehaviour = behaviour;
                this.myCustomActionDescription = customActionDescription;
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                V change = this.myBehaviour.performAction(e);
                if (change == null) {
                    return;
                }
                this.myCustomActionDescription.runPostHandlers(change);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                this.myBehaviour.updateAction(e);
            }
        }
    }

    public static interface ActionNotification<T> {
        public void afterActionPerformed(T var1);
    }

    protected static abstract class ActionDescription {
        protected ActionDescription() {
        }

        public abstract AnAction createAction(JComponent var1);
    }
}

