/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SuitableFontProvider;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleColoredComponent
extends JComponent
implements Accessible,
ColoredTextContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.SimpleColoredComponent");
    public static final int FRAGMENT_ICON = -2;
    private final List<ColoredFragment> myFragments;
    private ColoredFragment myCurrentFragment;
    private Font myLayoutFont;
    private Icon myIcon;
    private Insets myIpad;
    protected int myIconTextGap;
    private boolean myPaintFocusBorder;
    private boolean myFocusBorderAroundIcon;
    private Border myBorder;
    private int myMainTextLastIndex = -1;
    @JdkConstants.HorizontalAlignment
    private int myTextAlign = 2;
    private boolean myIconOpaque;
    private boolean myAutoInvalidate = !(this instanceof TreeCellRenderer);
    private boolean myIconOnTheRight;
    private boolean myTransparentIconBackground;

    public SimpleColoredComponent() {
        this.myFragments = new ArrayList<ColoredFragment>(3);
        this.myIpad = JBUI.insets((int)1, (int)2);
        this.myIconTextGap = JBUI.scale((int)2);
        this.myBorder = JBUI.Borders.empty((int)1, (int)(UIUtil.isUnderWin10LookAndFeel() ? 0 : 1));
        this.setOpaque(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        UISettings.setupComponentAntialiasing(this);
    }

    @NotNull
    public ColoredIterator iterator() {
        return new MyIterator();
    }

    public boolean isIconOnTheRight() {
        return this.myIconOnTheRight;
    }

    public void setIconOnTheRight(boolean iconOnTheRight) {
        this.myIconOnTheRight = iconOnTheRight;
    }

    @NotNull
    public final SimpleColoredComponent append(@NotNull String fragment) {
        this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return this;
    }

    @Override
    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
    }

    public final void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, int padding, @JdkConstants.HorizontalAlignment int align) {
        this.append(fragment, attributes, this.myMainTextLastIndex < 0);
        this.appendTextPadding(padding, align);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        this._append(fragment, attributes, isMainText);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            this.myCurrentFragment = new ColoredFragment(fragment, attributes);
            this.myFragments.add(this.myCurrentFragment);
            if (isMainText) {
                this.myMainTextLastIndex = this.myFragments.size() - 1;
            }
        }
    }

    void revalidateAndRepaint() {
        if (this.myAutoInvalidate) {
            this.revalidate();
        }
        this.repaint();
    }

    @Override
    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        this._append(fragment, attributes, tag);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _append(String fragment, SimpleTextAttributes attributes, Object tag) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            this.append(fragment, attributes);
            if (tag != null) {
                this.myCurrentFragment.tag = tag;
            }
        }
    }

    @Deprecated
    public void appendFixedTextFragmentWidth(int width) {
        this.appendTextPadding(width);
    }

    public void appendTextPadding(int padding) {
        this.appendTextPadding(padding, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendTextPadding(int padding, @JdkConstants.HorizontalAlignment int align) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (this.myCurrentFragment != null) {
                this.myCurrentFragment.padding = padding;
                this.myCurrentFragment.alignment = align;
            }
        }
    }

    public void setTextAlign(@JdkConstants.HorizontalAlignment int align) {
        this.myTextAlign = align;
    }

    public void clear() {
        this._clear();
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clear() {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            this.myIcon = null;
            this.myPaintFocusBorder = false;
            this.myFragments.clear();
            this.myCurrentFragment = null;
            this.myMainTextLastIndex = -1;
        }
    }

    public final Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public final void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        this.revalidateAndRepaint();
    }

    @NotNull
    public Insets getIpad() {
        return this.myIpad;
    }

    public void setIpad(@NotNull Insets ipad) {
        this.myIpad = ipad;
        this.revalidateAndRepaint();
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    public void setIconTextGap(int iconTextGap) {
        if (iconTextGap < 0) {
            throw new IllegalArgumentException("wrong iconTextGap: " + iconTextGap);
        }
        this.myIconTextGap = iconTextGap;
        this.revalidateAndRepaint();
    }

    public Border getMyBorder() {
        return this.myBorder;
    }

    public void setMyBorder(@Nullable Border border) {
        this.myBorder = border;
    }

    protected final void setPaintFocusBorder(boolean paintFocusBorder) {
        this.myPaintFocusBorder = paintFocusBorder;
        this.repaint();
    }

    protected final void setFocusBorderAroundIcon(boolean focusBorderAroundIcon) {
        this.myFocusBorderAroundIcon = focusBorderAroundIcon;
        this.repaint();
    }

    public boolean isIconOpaque() {
        return this.myIconOpaque;
    }

    public void setIconOpaque(boolean iconOpaque) {
        this.myIconOpaque = iconOpaque;
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.computePreferredSize(false);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.computePreferredSize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getFragmentTag(int index2) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (0 <= index2 && index2 < this.myFragments.size()) {
                return this.myFragments.get((int)index2).tag;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Dimension computePreferredSize(boolean mainTextOnly) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            int width = this.myIpad.left;
            if (this.myIcon != null) {
                width += this.myIcon.getIconWidth() + this.myIconTextGap;
            }
            JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
            width += borderInsets.left;
            Font font = this.getBaseFont();
            width = (int)((float)width + this.computeTextWidth(font, mainTextOnly));
            width += this.myIpad.right + borderInsets.right;
            Insets insets = this.getInsets();
            if (insets != null) {
                width += insets.left + insets.right;
            }
            int height = this.computePreferredHeight();
            return new Dimension(width, height);
        }
    }

    final synchronized int computePreferredHeight() {
        int height = this.myIpad.top + this.myIpad.bottom;
        Font font = this.getBaseFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int textHeight = Math.max(JBUI.scale((int)16), metrics.getHeight());
        JBInsets borderInsets = this.myBorder != null ? this.myBorder.getBorderInsets(this) : JBUI.emptyInsets();
        height += this.myIcon == null ? textHeight : Math.max(this.myIcon.getIconHeight(), textHeight += borderInsets.top + borderInsets.bottom);
        Insets insets = this.getInsets();
        if (insets != null) {
            height += insets.top + insets.bottom;
        }
        return height;
    }

    private Rectangle computePaintArea() {
        Rectangle area = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.getInsets());
        JBInsets.removeFrom((Rectangle)area, (Insets)this.myIpad);
        return area;
    }

    private float computeTextWidth(@NotNull Font font, boolean mainTextOnly) {
        float result2 = 0.0f;
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        for (int i = 0; i < this.myFragments.size(); ++i) {
            ColoredFragment fragment = this.myFragments.get(i);
            SimpleTextAttributes attributes = fragment.attributes;
            boolean isSmaller = attributes.isSmaller();
            if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
            }
            wasSmaller = isSmaller;
            result2 += this.computeStringWidth(fragment, font);
            int fixedWidth = fragment.padding;
            if (fixedWidth > 0 && result2 < (float)fixedWidth) {
                result2 = fixedWidth;
            }
            if (mainTextOnly && this.myMainTextLastIndex >= 0 && i == this.myMainTextLastIndex) break;
        }
        return result2;
    }

    @NotNull
    private Font getBaseFont() {
        Font font = this.getFont();
        if (font == null) {
            font = UIUtil.getLabelFont();
        }
        return font;
    }

    private TextLayout getTextLayout(@NotNull ColoredFragment fragment, Font font, FontRenderContext frc) {
        TextLayout layout;
        if (this.getBaseFont() != this.myLayoutFont) {
            this.myFragments.forEach(each -> {
                each.layout = null;
            });
        }
        if ((layout = fragment.layout) == null && SimpleColoredComponent.needFontFallback(font, fragment.text)) {
            layout = this.createAndCacheTextLayout(fragment, font, frc);
        }
        return layout;
    }

    private void doDrawString(Graphics2D g, @NotNull ColoredFragment fragment, float x, float y) {
        String text = fragment.text;
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        TextLayout layout = this.getTextLayout(fragment, g.getFont(), g.getFontRenderContext());
        if (layout != null) {
            layout.draw(g, x, y);
        } else {
            g.drawString(text, x, y);
        }
    }

    private float computeStringWidth(@NotNull ColoredFragment fragment, Font font) {
        String text = fragment.text;
        if (StringUtil.isEmpty((String)text)) {
            return 0.0f;
        }
        FontRenderContext fontRenderContext = this.getFontMetrics(font).getFontRenderContext();
        TextLayout layout = this.getTextLayout(fragment, font, fontRenderContext);
        return layout != null ? layout.getAdvance() : (float)font.getStringBounds(text, fontRenderContext).getWidth();
    }

    private TextLayout createAndCacheTextLayout(@NotNull ColoredFragment fragment, Font basefont, FontRenderContext fontRenderContext) {
        TextLayout layout;
        String text = fragment.text;
        AttributedString string = new AttributedString(text);
        int start = 0;
        int end = text.length();
        AttributedCharacterIterator it = string.getIterator(new AttributedCharacterIterator.Attribute[0], start, end);
        Font currentFont = basefont;
        int currentIndex = start;
        char c = it.first();
        while (c != '\uffff') {
            Font font = basefont;
            if (!font.canDisplay(c)) {
                SuitableFontProvider provider;
                SuitableFontProvider[] suitableFontProviderArray = (SuitableFontProvider[])SuitableFontProvider.EP_NAME.getExtensions();
                int n = suitableFontProviderArray.length;
                for (int i = 0; i < n && (font = (provider = suitableFontProviderArray[i]).getFontAbleToDisplay(c, basefont.getSize(), basefont.getStyle(), basefont.getFamily())) == null; ++i) {
                }
            }
            int i = it.getIndex();
            if (!Comparing.equal((Object)currentFont, (Object)font)) {
                if (i > currentIndex) {
                    string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, i);
                }
                currentFont = font;
                currentIndex = i;
            }
            c = it.next();
        }
        if (currentIndex < end) {
            string.addAttribute(TextAttribute.FONT, currentFont, currentIndex, end);
        }
        fragment.layout = layout = new TextLayout(string.getIterator(), fontRenderContext);
        this.myLayoutFont = this.getBaseFont();
        return layout;
    }

    private static boolean needFontFallback(Font font, String text) {
        return font.canDisplayUpTo(text) != -1 && text.indexOf(65535) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findFragmentAt(int x) {
        float curX = this.myIpad.left;
        if (this.myIcon != null && !this.myIconOnTheRight) {
            int iconRight = this.myIcon.getIconWidth() + this.myIconTextGap;
            if (x < iconRight) {
                return -2;
            }
            curX += (float)iconRight;
        }
        Font font = this.getBaseFont();
        int baseSize = font.getSize();
        boolean wasSmaller = false;
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            for (int i = 0; i < this.myFragments.size(); ++i) {
                ColoredFragment fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = fragment.attributes;
                boolean isSmaller = attributes.isSmaller();
                if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                    font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
                }
                wasSmaller = isSmaller;
                float curWidth = this.computeStringWidth(fragment, font);
                if ((float)x >= curX && (float)x < curX + curWidth) {
                    return i;
                }
                curX += curWidth;
                int fragmentPadding = fragment.padding;
                if (fragmentPadding <= 0 || !(curX < (float)fragmentPadding)) continue;
                curX = fragmentPadding;
            }
        }
        if (this.myIcon != null && this.myIconOnTheRight && (float)x >= (curX += (float)this.myIconTextGap) && (float)x < curX + (float)this.myIcon.getIconWidth()) {
            return -2;
        }
        return -1;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        int index2 = this.findFragmentAt(x);
        return index2 < 0 ? null : this.getFragmentTag(index2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected JLabel formatToLabel(@NotNull JLabel label) {
        label.setIcon(this.myIcon);
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (!this.myFragments.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("<html><body style=\"white-space:nowrap\">");
                for (ColoredFragment fragment : this.myFragments) {
                    String text = fragment.text;
                    SimpleTextAttributes attributes = fragment.attributes;
                    Object tag = fragment.tag;
                    if (tag instanceof BrowserLauncherTag) {
                        SimpleColoredComponent.formatLink(sb, text, attributes, ((BrowserLauncherTag)tag).myUrl);
                        continue;
                    }
                    SimpleColoredComponent.formatText(sb, text, attributes);
                }
                sb.append("</body></html>");
                label.setText(sb.toString());
            }
        }
        return label;
    }

    static void formatText(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (!fragment.isEmpty()) {
            builder.append("<span");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</span>");
        }
    }

    static void formatLink(@NotNull StringBuilder builder, @NotNull String fragment, @NotNull SimpleTextAttributes attributes, @NotNull String url) {
        if (!fragment.isEmpty()) {
            builder.append("<a href=\"").append(StringUtil.replace((String)url, (String)"\"", (String)"%22")).append("\"");
            SimpleColoredComponent.formatStyle(builder, attributes);
            builder.append('>').append(SimpleColoredComponent.convertFragment(fragment)).append("</a>");
        }
    }

    private static String convertFragment(@NotNull String fragment) {
        return StringUtil.escapeXmlEntities((String)fragment).replaceAll("\\\\n", "<br>");
    }

    private static void formatStyle(StringBuilder builder, SimpleTextAttributes attributes) {
        Color fgColor = attributes.getFgColor();
        Color bgColor = attributes.getBgColor();
        int style = attributes.getStyle();
        int pos = builder.length();
        if (fgColor != null) {
            builder.append("color:").append(ColorUtil.toHtmlColor((Color)fgColor)).append(';');
        }
        if (bgColor != null) {
            builder.append("background-color:").append(ColorUtil.toHtmlColor((Color)bgColor)).append(';');
        }
        if ((style & 1) != 0) {
            builder.append("font-weight:bold;");
        }
        if ((style & 2) != 0) {
            builder.append("font-style:italic;");
        }
        if ((style & 0x10) != 0) {
            builder.append("text-decoration:underline;");
        } else if ((style & 4) != 0) {
            builder.append("text-decoration:line-through;");
        }
        if (builder.length() > pos) {
            builder.insert(pos, " style=\"");
            builder.append('\"');
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            this.doPaint((Graphics2D)g);
        }
        catch (RuntimeException e) {
            LOG.error(this.logSwingPath(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPaint(Graphics2D g) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            int offset = 0;
            Icon icon = this.myIcon;
            if (icon != null && !this.myIconOnTheRight) {
                this.doPaintIcon(g, icon, 0);
                offset += this.myIpad.left + icon.getIconWidth() + this.myIconTextGap;
            }
            this.doPaintTextBackground(g, offset);
            offset = this.doPaintText(g, offset, this.myFocusBorderAroundIcon || icon == null) + this.myIconTextGap;
            if (icon != null && this.myIconOnTheRight) {
                this.doPaintIcon(g, icon, offset);
            }
        }
    }

    private void doPaintTextBackground(Graphics2D g, int offset) {
        if (this.isOpaque() || this.shouldDrawBackground()) {
            this.paintBackground(g, offset, this.getWidth() - offset, this.getHeight());
        }
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.getBackground());
        g.fillRect(x, 0, width, height);
    }

    protected void doPaintIcon(@NotNull Graphics2D g, @NotNull Icon icon, int offset) {
        Container parent = this.getParent();
        Color iconBackgroundColor = null;
        if ((this.isOpaque() || this.isIconOpaque()) && !this.isTransparentIconBackground()) {
            iconBackgroundColor = parent != null && !this.myFocusBorderAroundIcon && !UIUtil.isFullRowSelectionLAF() ? parent.getBackground() : this.getBackground();
        }
        if (iconBackgroundColor != null) {
            g.setColor(iconBackgroundColor);
            g.fillRect(offset, 0, icon.getIconWidth() + this.myIpad.left + this.myIconTextGap, this.getHeight());
        }
        this.paintIcon(g, icon, offset + this.myIpad.left);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPaintText(Graphics2D g, int textStart, boolean focusAroundIcon) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            if (textStart == 0) {
                textStart = this.myIpad.left;
            }
            float offset = textStart;
            if (this.myBorder != null) {
                offset += (float)this.myBorder.getBorderInsets((Component)this).left;
            }
            offset += (float)this.getInsets().left;
            int height = this.getHeight();
            this.applyAdditionalHints(g);
            Font baseFont = this.getBaseFont();
            g.setFont(baseFont);
            offset += (float)this.computeTextAlignShift();
            int baseSize = baseFont.getSize();
            FontMetrics baseMetrics = g.getFontMetrics();
            Rectangle area = this.computePaintArea();
            int textBaseline = area.y + SimpleColoredComponent.getTextBaseLine(baseMetrics, area.height);
            boolean wasSmaller = false;
            class Frag {
                private final int index;
                private final float start;
                private final float end;
                private final float baseLine;
                private final Font font;
                private final Frag next;

                Frag(int index2, float start, float end, @NotNull float baseLine, Font font, Frag next) {
                    this.index = index2;
                    this.start = start;
                    this.end = end;
                    this.baseLine = baseLine;
                    this.font = font;
                    this.next = next;
                }
            }
            Frag secondPassFrag = null;
            for (int i = 0; i < this.myFragments.size(); ++i) {
                float endOffset;
                Color bgColor;
                ColoredFragment fragment = this.myFragments.get(i);
                SimpleTextAttributes attributes = fragment.attributes;
                Font font = g.getFont();
                boolean isSmaller = attributes.isSmaller();
                if (font.getStyle() != attributes.getFontStyle() || isSmaller != wasSmaller) {
                    font = font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)baseSize);
                }
                wasSmaller = isSmaller;
                g.setFont(font);
                FontMetrics metrics = g.getFontMetrics(font);
                float fragmentWidth = this.computeStringWidth(fragment, font);
                int fragmentPadding = fragment.padding;
                boolean secondPass = attributes.isSearchMatch() || attributes.isClickable();
                Color color = bgColor = secondPass ? null : attributes.getBgColor();
                if ((attributes.isOpaque() || this.isOpaque()) && bgColor != null) {
                    this.doPaintFragmentBackground(g, i, bgColor, (int)offset, 0, (int)fragmentWidth, height);
                }
                Color color2 = this.isEnabled() ? this.getActiveTextColor(attributes.getFgColor()) : UIUtil.getInactiveTextColor();
                g.setColor(color2);
                int fragmentAlignment = fragment.alignment;
                if (fragmentPadding > 0 && (float)fragmentPadding > fragmentWidth) {
                    endOffset = fragmentPadding;
                    if (fragmentAlignment == 4 || fragmentAlignment == 11) {
                        offset = (float)fragmentPadding - fragmentWidth;
                    }
                } else {
                    endOffset = offset + fragmentWidth;
                }
                if (!secondPass) {
                    if (this.shouldDrawDimmed()) {
                        color2 = ColorUtil.dimmer((Color)color2);
                    }
                    g.setColor(color2);
                    this.doDrawString(g, fragment, offset, textBaseline);
                    g.setStroke(g.getStroke());
                    this.drawTextAttributes(g, attributes, (int)offset, textBaseline, (int)fragmentWidth, metrics, font);
                }
                if (secondPass) {
                    secondPassFrag = new Frag(i, offset, offset + fragmentWidth, textBaseline, font, secondPassFrag);
                }
                offset = endOffset;
            }
            if (this.myPaintFocusBorder && this.myBorder != null) {
                int width = this.getWidth();
                if (focusAroundIcon) {
                    this.myBorder.paintBorder(this, g, 0, 0, width, height);
                } else {
                    this.myBorder.paintBorder(this, g, textStart, 0, width - textStart, height);
                }
            }
            Frag frag = secondPassFrag;
            while (frag != null) {
                block24: {
                    Object fgColor;
                    SimpleTextAttributes attributes;
                    String text;
                    float baseline;
                    float x2;
                    float x1;
                    block23: {
                        block22: {
                            x1 = frag.start;
                            x2 = frag.end;
                            baseline = frag.baseLine;
                            ColoredFragment fragment = this.myFragments.get(frag.index);
                            text = fragment.text;
                            attributes = fragment.attributes;
                            if (!attributes.isSearchMatch()) break block22;
                            fgColor = new JBColor((Color)Gray._50, (Color)Gray._0);
                            UIUtil.drawSearchMatch((Graphics2D)g, (float)x1, (float)x2, (int)height);
                            break block23;
                        }
                        if (!attributes.isClickable()) break block24;
                        fgColor = (Color)ObjectUtils.notNull((Object)attributes.getFgColor(), (Object)UIUtil.getLabelForeground());
                        Color bg = (Color)ObjectUtils.notNull((Object)attributes.getBgColor(), (Object)UIUtil.getLabelBackground());
                        SimpleColoredComponent.drawClickableFrag(g, x1, x2, height, bg);
                    }
                    g.setFont(frag.font);
                    g.setColor((Color)fgColor);
                    g.drawString(text, x1, baseline);
                    int fragmentWidth = (int)(x2 - x1);
                    this.drawTextAttributes(g, attributes, (int)x1, (int)baseline, fragmentWidth, g.getFontMetrics(), g.getFont());
                }
                frag = frag.next;
            }
            return (int)offset;
        }
    }

    protected Color getActiveTextColor(Color attributesColor) {
        return attributesColor != null ? attributesColor : this.getForeground();
    }

    protected void doPaintFragmentBackground(@NotNull Graphics2D g, int index2, @NotNull Color bgColor, int x, int y, int width, int height) {
        g.setColor(bgColor);
        g.fillRect(x, y, width, height);
    }

    private static void drawClickableFrag(Graphics2D g, float x1, float x2, int height, Color bg) {
        boolean darcula = UIUtil.isUnderDarcula();
        Color c1 = darcula ? bg.brighter() : bg;
        Color c2 = darcula ? bg : bg.darker();
        GraphicsConfig c = GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)g);
        g.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g.setPaint(UIUtil.getGradientPaint((float)(x1 + 1.0f), (float)2.0f, (Color)c1, (float)(x1 + 1.0f), (float)(height - 5), (Color)c2));
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x1 + 1.0f, 2.0f, x2 - x1 - 2.0f, height - 4, 4.0f, 4.0f);
        g.fill(shape);
        g.setColor((Color)new JBColor((Color)Gray.xCC, new Color(7699328)));
        g.draw(shape);
        c.restore();
    }

    private void drawTextAttributes(@NotNull Graphics2D g, @NotNull SimpleTextAttributes attributes, int offset, int textBaseline, int fragmentWidth, @NotNull FontMetrics metrics, Font font) {
        if (attributes.isStrikeout()) {
            EffectPainter.STRIKE_THROUGH.paint(g, offset, textBaseline, fragmentWidth, SimpleColoredComponent.getCharHeight(g), font);
        }
        if (attributes.isWaved()) {
            if (attributes.getWaveColor() != null) {
                g.setColor(attributes.getWaveColor());
            }
            EffectPainter.WAVE_UNDERSCORE.paint(g, offset, textBaseline + 1, fragmentWidth, Math.max(2, metrics.getDescent()), font);
        }
        if (attributes.isUnderline()) {
            EffectPainter.LINE_UNDERSCORE.paint(g, offset, textBaseline, fragmentWidth, metrics.getDescent(), font);
        }
        if (attributes.isBoldDottedLine()) {
            int dottedAt = SystemInfo.isMac ? textBaseline : textBaseline + 1;
            Color lineColor = attributes.getWaveColor();
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)offset, (int)(offset + fragmentWidth), (int)dottedAt, (Color)attributes.getBgColor(), (Color)lineColor, (boolean)this.isOpaque());
        }
    }

    private static int getCharHeight(Graphics g) {
        return g.getFontMetrics().charWidth('a');
    }

    private int computeTextAlignShift() {
        if (this.myTextAlign == 2 || this.myTextAlign == 10) {
            return 0;
        }
        int componentWidth = this.getSize().width;
        int excessiveWidth = componentWidth - this.computePreferredSize((boolean)false).width;
        if (excessiveWidth <= 0) {
            return 0;
        }
        if (this.myTextAlign == 0) {
            return excessiveWidth / 2;
        }
        if (this.myTextAlign == 4 || this.myTextAlign == 11) {
            return excessiveWidth;
        }
        return 0;
    }

    @Deprecated
    protected boolean shouldDrawMacShadow() {
        return false;
    }

    protected boolean shouldDrawDimmed() {
        return false;
    }

    protected boolean shouldDrawBackground() {
        return false;
    }

    protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
        Rectangle area = this.computePaintArea();
        icon.paintIcon(this, g, offset, area.y + (area.height - icon.getIconHeight() + 1) / 2);
    }

    protected void applyAdditionalHints(@NotNull Graphics2D g) {
        UISettings.setupAntialiasing(g);
    }

    @Override
    public int getBaseline(int width, int height) {
        super.getBaseline(width, height);
        return SimpleColoredComponent.getTextBaseLine(this.getFontMetrics(this.getFont()), height);
    }

    public boolean isTransparentIconBackground() {
        return this.myTransparentIconBackground;
    }

    public void setTransparentIconBackground(boolean transparentIconBackground) {
        this.myTransparentIconBackground = transparentIconBackground;
    }

    public static int getTextBaseLine(@NotNull FontMetrics metrics, int height) {
        return (height - metrics.getHeight()) / 2 + metrics.getAscent() + (SystemInfo.isJetBrainsJvm ? metrics.getLeading() : 0);
    }

    @NotNull
    private String logSwingPath() {
        StringBuilder buffer = new StringBuilder("Components hierarchy:\n");
        for (Container c = this; c != null; c = c.getParent()) {
            buffer.append('\n');
            buffer.append(c);
        }
        return buffer.toString();
    }

    protected void setBorderInsets(Insets insets) {
        this.myBorder = new JBEmptyBorder(insets);
        this.revalidateAndRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CharSequence getCharSequence(boolean mainOnly) {
        List<ColoredFragment> list = this.myFragments;
        synchronized (list) {
            int count = this.myFragments.size();
            if (count == 0) {
                return "";
            }
            if (mainOnly && this.myMainTextLastIndex > -1 && this.myMainTextLastIndex + 1 < this.myFragments.size()) {
                count = this.myMainTextLastIndex + 1;
            }
            StringBuilder sb = new StringBuilder(this.myFragments.get((int)0).text);
            for (int i = 1; i < count; ++i) {
                sb.append(this.myFragments.get((int)i).text);
            }
            return sb.toString();
        }
    }

    @Override
    public String toString() {
        return this.getCharSequence(false).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(@NotNull Runnable runnable, boolean autoInvalidate) {
        boolean old = this.myAutoInvalidate;
        this.myAutoInvalidate = autoInvalidate;
        try {
            runnable.run();
        }
        finally {
            this.myAutoInvalidate = old;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSimpleColoredComponent();
        }
        return this.accessibleContext;
    }

    private static class ColoredFragment {
        @NotNull
        volatile String text;
        @NotNull
        volatile SimpleTextAttributes attributes;
        @Nullable
        volatile Object tag;
        @Nullable
        volatile TextLayout layout;
        volatile int padding;
        volatile int alignment;

        ColoredFragment(@NotNull String text, @NotNull SimpleTextAttributes attributes) {
            this.text = text;
            this.attributes = attributes;
        }
    }

    private class MyIterator
    implements ColoredIterator {
        int myIndex = -1;
        int myOffset;
        int myEndOffset;

        private MyIterator() {
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getEndOffset() {
            return this.myEndOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public String getFragment() {
            List list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                return ((ColoredFragment)((SimpleColoredComponent)SimpleColoredComponent.this).myFragments.get((int)this.myIndex)).text;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public SimpleTextAttributes getTextAttributes() {
            List list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                return ((ColoredFragment)((SimpleColoredComponent)SimpleColoredComponent.this).myFragments.get((int)this.myIndex)).attributes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int split(int offset, @NotNull SimpleTextAttributes attributes) {
            List list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                if (offset < 0 || offset > this.myEndOffset - this.myOffset) {
                    throw new IllegalArgumentException(offset + " is not within [0, " + (this.myEndOffset - this.myOffset) + "]");
                }
                ColoredFragment oldFragment = (ColoredFragment)SimpleColoredComponent.this.myFragments.get(this.myIndex);
                if (offset == this.myEndOffset - this.myOffset) {
                    oldFragment.attributes = attributes;
                } else if (offset > 0) {
                    String text = this.getFragment();
                    ColoredFragment newFragment = new ColoredFragment(text.substring(offset), oldFragment.attributes);
                    oldFragment.text = text.substring(0, offset);
                    oldFragment.attributes = attributes;
                    newFragment.tag = oldFragment;
                    SimpleColoredComponent.this.myFragments.add(this.myIndex + 1, newFragment);
                    ++this.myIndex;
                }
                this.myOffset += offset;
                return this.myOffset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            List list = SimpleColoredComponent.this.myFragments;
            synchronized (list) {
                return this.myIndex + 1 < SimpleColoredComponent.this.myFragments.size();
            }
        }

        @Override
        public String next() {
            ++this.myIndex;
            this.myOffset = this.myEndOffset;
            String text = this.getFragment();
            this.myEndOffset += text.length();
            return text;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ColoredIterator
    extends Iterator<String> {
        public int getOffset();

        public int getEndOffset();

        @NotNull
        public String getFragment();

        @NotNull
        public SimpleTextAttributes getTextAttributes();

        public int split(int var1, @NotNull SimpleTextAttributes var2);
    }

    public static class BrowserLauncherTag
    implements Runnable {
        private final String myUrl;

        public BrowserLauncherTag(@NotNull String url) {
            this.myUrl = url;
        }

        @Override
        public void run() {
            BrowserUtil.browse(this.myUrl);
        }
    }

    protected class AccessibleSimpleColoredComponent
    extends JComponent.AccessibleJComponent {
        protected AccessibleSimpleColoredComponent() {
            super(SimpleColoredComponent.this);
        }

        @Override
        public String getAccessibleName() {
            return SimpleColoredComponent.this.getCharSequence(false).toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

