/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizedIcon
extends JBUI.CachingScalableJBIcon
implements IconLoader.MenuBarIconProvider,
IconLoader.DarkIconProvider,
RetrievableIcon {
    private final int myWidth;
    private final int myHeight;
    private final Icon myDelegate;
    private Icon myScaledDelegate;

    public SizedIcon(Icon delegate, int width, int height) {
        this.myScaledDelegate = this.myDelegate = delegate;
        this.myWidth = width;
        this.myHeight = height;
    }

    protected SizedIcon(SizedIcon icon) {
        super((JBUI.CachingScalableJBIcon)icon);
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myDelegate = icon.myDelegate;
        this.myScaledDelegate = null;
    }

    @NotNull
    public SizedIcon copy() {
        return new SizedIcon(this);
    }

    private Icon myScaledIcon() {
        if (this.myScaledDelegate != null) {
            return this.myScaledDelegate;
        }
        if (this.getScale() == 1.0f) {
            this.myScaledDelegate = this.myDelegate;
            return this.myScaledDelegate;
        }
        if (!(this.myDelegate instanceof ScalableIcon)) {
            this.myScaledDelegate = this.myDelegate;
            return this.myScaledDelegate;
        }
        this.myScaledDelegate = ((ScalableIcon)this.myDelegate).scale(this.getScale());
        return this.myScaledDelegate;
    }

    public Icon getMenuBarIcon(boolean isDark) {
        return new SizedIcon(IconLoader.getMenuBarIcon((Icon)this.myDelegate, (boolean)isDark), this.myWidth, this.myHeight);
    }

    public Icon getDarkIcon(boolean isDark) {
        return new SizedIcon(IconLoader.getDarkIcon((Icon)this.myDelegate, (boolean)isDark), this.myWidth, this.myHeight);
    }

    @Nullable
    public Icon retrieveIcon() {
        return this.myDelegate;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.myScaledIcon();
        double dx = this.scaleVal(this.myWidth) - (double)icon.getIconWidth();
        double dy = this.scaleVal(this.myHeight) - (double)icon.getIconHeight();
        if (dx > 0.0 || dy > 0.0) {
            icon.paintIcon(c, g, x + (int)Math.floor(dx / 2.0), y + (int)Math.floor(dy / 2.0));
        } else {
            icon.paintIcon(c, g, x, y);
        }
    }

    public int getIconWidth() {
        return (int)Math.ceil(this.scaleVal(this.myWidth));
    }

    public int getIconHeight() {
        return (int)Math.ceil(this.scaleVal(this.myHeight));
    }
}

