/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.ui.ComponentTreeWatcher;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class UserActivityWatcher
extends ComponentTreeWatcher {
    private boolean myIsModified = false;
    private final EventDispatcher<UserActivityListener> myListeners = EventDispatcher.create(UserActivityListener.class);
    private final DocumentListener myDocumentListener = new DocumentAdapter(){

        public void textChanged(@NotNull javax.swing.event.DocumentEvent event) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final com.intellij.openapi.editor.event.DocumentListener myIdeaDocumentListener = new com.intellij.openapi.editor.event.DocumentListener(){

        @Override
        public void documentChanged(@NotNull DocumentEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final TableModelListener myTableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final PropertyChangeListener myTableListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TableModel newModel;
            TableModel oldModel = (TableModel)evt.getOldValue();
            if (oldModel != null) {
                oldModel.removeTableModelListener(UserActivityWatcher.this.myTableModelListener);
            }
            if ((newModel = (TableModel)evt.getNewValue()) != null) {
                newModel.addTableModelListener(UserActivityWatcher.this.myTableModelListener);
            }
            if (oldModel != null) {
                UserActivityWatcher.this.fireUIChanged();
            }
        }
    };
    private final ChangeListener myChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final PropertyChangeListener myCellEditorChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getOldValue() != null && e.getNewValue() == null) {
                UserActivityWatcher.this.fireUIChanged();
            }
        }
    };
    private final ItemListener myItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final ListDataListener myListDataListener = new ListDataListener(){

        @Override
        public void intervalAdded(ListDataEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final ListSelectionListener myListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };
    private final TreeModelListener myTreeModelListener = new TreeModelListener(){

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            UserActivityWatcher.this.fireUIChanged();
        }
    };

    public void addUserActivityListener(UserActivityListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void addUserActivityListener(UserActivityListener listener, Disposable parentDisposable) {
        this.myListeners.addListener((EventListener)listener, parentDisposable);
    }

    public void removeUserActivityListener(UserActivityListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    protected final void fireUIChanged() {
        this.myIsModified = true;
        ((UserActivityListener)this.myListeners.getMulticaster()).stateChanged();
    }

    public UserActivityWatcher(Class[] controlsToIgnore) {
        super(controlsToIgnore);
    }

    public UserActivityWatcher() {
        this(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    @Override
    protected boolean processChildren(Container container) {
        return !(container instanceof JTable);
    }

    @Override
    protected void processComponent(Component parentComponent) {
        ComboBoxEditor editor;
        if (parentComponent instanceof JTextComponent) {
            ((JTextComponent)parentComponent).getDocument().addDocumentListener(this.myDocumentListener);
        } else if (parentComponent instanceof EditorTextComponent) {
            ((EditorTextComponent)((Object)parentComponent)).addDocumentListener(this.myIdeaDocumentListener);
        } else if (parentComponent instanceof ItemSelectable) {
            ((ItemSelectable)((Object)parentComponent)).addItemListener(this.myItemListener);
        } else if (parentComponent instanceof JList) {
            ((JList)parentComponent).getModel().addListDataListener(this.myListDataListener);
            ((JList)parentComponent).addListSelectionListener(this.myListSelectionListener);
        } else if (parentComponent instanceof JTree) {
            ((JTree)parentComponent).getModel().addTreeModelListener(this.myTreeModelListener);
        }
        if (parentComponent instanceof JComboBox && (editor = ((JComboBox)parentComponent).getEditor()) != null) {
            this.register(editor.getEditorComponent());
        }
        if (parentComponent instanceof JTable) {
            JTable table = (JTable)parentComponent;
            table.addPropertyChangeListener("model", this.myTableListener);
            TableModel model = table.getModel();
            if (model != null) {
                model.addTableModelListener(this.myTableModelListener);
            }
            table.addPropertyChangeListener("tableCellEditor", this.myCellEditorChangeListener);
        }
        if (parentComponent instanceof JSlider) {
            ((JSlider)parentComponent).addChangeListener(this.myChangeListener);
        }
        if (parentComponent instanceof UserActivityProviderComponent) {
            ((UserActivityProviderComponent)((Object)parentComponent)).addChangeListener(this.myChangeListener);
        }
    }

    @Override
    protected void unprocessComponent(Component component) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).getDocument().removeDocumentListener(this.myDocumentListener);
        } else if (component instanceof EditorTextComponent) {
            ((EditorTextComponent)((Object)component)).removeDocumentListener(this.myIdeaDocumentListener);
        } else if (component instanceof ItemSelectable) {
            ((ItemSelectable)((Object)component)).removeItemListener(this.myItemListener);
        } else if (component instanceof JTree) {
            ((JTree)component).getModel().removeTreeModelListener(this.myTreeModelListener);
        }
        if (component instanceof JTable) {
            component.removePropertyChangeListener(this.myTableListener);
            TableModel model = ((JTable)component).getModel();
            if (model != null) {
                model.removeTableModelListener(this.myTableModelListener);
            }
            component.removePropertyChangeListener(this.myCellEditorChangeListener);
        }
        if (component instanceof JSlider) {
            ((JSlider)component).removeChangeListener(this.myChangeListener);
        }
        if (component instanceof UserActivityProviderComponent) {
            ((UserActivityProviderComponent)((Object)component)).removeChangeListener(this.myChangeListener);
        }
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void commit() {
        this.myIsModified = false;
    }
}

