/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class JBTextArea
extends JTextArea {
    public JBTextArea() {
        this(null, null, 0, 0);
    }

    public JBTextArea(String text) {
        this(null, text, 0, 0);
    }

    public JBTextArea(int rows, int columns) {
        this(null, null, rows, columns);
    }

    public JBTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }

    public JBTextArea(Document doc) {
        this(doc, null, 0, 0);
    }

    public JBTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                JBTextArea.this.invalidate();
                JBTextArea.this.revalidate();
                JBTextArea.this.repaint();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        Insets insets = this.getInsets();
        String[] lines = this.getText().split("\n");
        int columns = 0;
        int rows = lines.length;
        for (String line : lines) {
            columns = Math.max(columns, line.length());
        }
        if (columns != 0) {
            d.width = Math.max(d.width, columns * this.getColumnWidth() + insets.left + insets.right);
        }
        if (rows != 0) {
            d.height = Math.max(d.height, rows * this.getRowHeight() + insets.top + insets.bottom);
        }
        return d;
    }

    @Override
    public void scrollRectToVisible(Rectangle r) {
        JViewport viewport = (JViewport)UIUtil.getParentOfType(JViewport.class, (Component)this);
        if (viewport != null) {
            r = SwingUtilities.convertRectangle(this, r, viewport);
            viewport.scrollRectToVisible(r);
        }
    }
}

