/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.MixedColorProducer;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ScrollBarPainter
implements RegionPainter<Float> {
    final Rectangle bounds = new Rectangle();
    final TwoWayAnimator animator;
    private static final ColorKey BACKGROUND = ScrollBarPainter.key(-657931, -12631484, "ScrollBar.background");
    private static final ColorKey TRACK_OPAQUE_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.trackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.trackColor");
    private static final ColorKey TRACK_OPAQUE_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.hoverTrackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.hoverTrackColor");
    private static final ColorKey TRACK_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Mac.Transparent.trackColor") : ScrollBarPainter.key(0x808080, 0x808080, "ScrollBar.Transparent.trackColor");
    private static final ColorKey TRACK_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(444629120, 444629120, "ScrollBar.Mac.Transparent.hoverTrackColor") : ScrollBarPainter.key(444629120, 444629120, "ScrollBar.Transparent.hoverTrackColor");
    private static final ColorKey THUMB_OPAQUE_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x33000000, 1495672358, "ScrollBar.Mac.thumbBorderColor") : ScrollBarPainter.key(0x33595959, 1194866744, "ScrollBar.thumbBorderColor");
    private static final ColorKey THUMB_OPAQUE_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0x33000000, 1501593728, "ScrollBar.Mac.thumbColor") : ScrollBarPainter.key(0x33737373, 1202103974, "ScrollBar.thumbColor");
    private static final ColorKey THUMB_OPAQUE_HOVERED_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1943656922, "ScrollBar.Mac.hoverThumbBorderColor") : ScrollBarPainter.key(1197037913, 1496856632, "ScrollBar.hoverThumbBorderColor");
    private static final ColorKey THUMB_OPAQUE_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1937735552, "ScrollBar.Mac.hoverThumbColor") : ScrollBarPainter.key(0x47737373, 1504093862, "ScrollBar.hoverThumbColor");
    private static final ColorKey THUMB_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0, 0x262626, "ScrollBar.Mac.Transparent.thumbBorderColor") : ScrollBarPainter.key(0x33595959, 1194866744, "ScrollBar.Transparent.thumbBorderColor");
    private static final ColorKey THUMB_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(0, 0x808080, "ScrollBar.Mac.Transparent.thumbColor") : ScrollBarPainter.key(0x33737373, 1202103974, "ScrollBar.Transparent.thumbColor");
    private static final ColorKey THUMB_HOVERED_FOREGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1943656922, "ScrollBar.Mac.Transparent.hoverThumbBorderColor") : ScrollBarPainter.key(1197037913, 1496856632, "ScrollBar.Transparent.hoverThumbBorderColor");
    private static final ColorKey THUMB_HOVERED_BACKGROUND = SystemInfo.isMac ? ScrollBarPainter.key(Integer.MIN_VALUE, -1937735552, "ScrollBar.Mac.Transparent.hoverThumbColor") : ScrollBarPainter.key(0x47737373, 1504093862, "ScrollBar.Transparent.hoverThumbColor");

    protected ScrollBarPainter(final @NotNull Supplier<? extends Component> supplier) {
        this.animator = new TwoWayAnimator(this.getClass().getName(), 11, 150, 125, 300, 125){

            @Override
            void onValueUpdate() {
                Component component = (Component)supplier.get();
                if (component != null) {
                    component.repaint();
                }
            }
        };
    }

    @NotNull
    private static ColorKey key(int light, int dark, @NotNull String name) {
        return ColorKey.createColorKey(name, (Color)JBColor.namedColor((String)name, (Color)new JBColor(new Color(light, true), new Color(dark, true))));
    }

    @NotNull
    static Color getColor(@Nullable Component component, @NotNull ColorKey key) {
        Function function = (Function)UIUtil.getClientProperty((Object)component, ColorKey.FUNCTION_KEY);
        Color color = function == null ? null : (Color)function.apply(key);
        return color != null ? color : key.getDefaultColor();
    }

    static Color getColor(@NotNull Supplier<? extends Component> supplier, @NotNull ColorKey key) {
        return new JBColor(() -> ScrollBarPainter.getColor((Component)supplier.get(), key));
    }

    static Color getColor(@NotNull Supplier<? extends Component> supplier, @NotNull ColorKey transparent, @NotNull ColorKey opaque) {
        return new JBColor(() -> {
            Component component;
            return ScrollBarPainter.getColor(component, (component = (Component)supplier.get()) != null && DefaultScrollBarUI.isOpaque(component) ? opaque : transparent);
        });
    }

    static void setBackground(@NotNull Component component) {
        component.setBackground((Color)new JBColor(() -> ScrollBarPainter.getColor(component, BACKGROUND)));
    }

    static final class Thumb
    extends ScrollBarPainter {
        private final MixedColorProducer fillProducer;
        private final MixedColorProducer drawProducer;

        Thumb(@NotNull Supplier<? extends Component> supplier, boolean opaque) {
            super(supplier);
            this.fillProducer = new MixedColorProducer(opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_BACKGROUND) : Thumb.getColor(supplier, THUMB_BACKGROUND, THUMB_OPAQUE_BACKGROUND), opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_HOVERED_BACKGROUND) : Thumb.getColor(supplier, THUMB_HOVERED_BACKGROUND, THUMB_OPAQUE_HOVERED_BACKGROUND));
            this.drawProducer = new MixedColorProducer(opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_FOREGROUND) : Thumb.getColor(supplier, THUMB_FOREGROUND, THUMB_OPAQUE_FOREGROUND), opaque ? Thumb.getColor(supplier, THUMB_OPAQUE_HOVERED_FOREGROUND) : Thumb.getColor(supplier, THUMB_HOVERED_FOREGROUND, THUMB_OPAQUE_HOVERED_FOREGROUND));
        }

        public void paint(Graphics2D g, int x, int y, int width, int height, @Nullable Float value) {
            double mixer = value == null ? 0.0 : value.doubleValue();
            Color fill = this.fillProducer.produce(mixer);
            Color draw = this.drawProducer.produce(mixer);
            if (fill.getRGB() == draw.getRGB()) {
                draw = null;
            }
            int arc = 0;
            if (SystemInfo.isMac) {
                int margin = draw == null ? 2 : 1;
                x += margin;
                y += margin;
                arc = Math.min(width -= margin + margin, height -= margin + margin);
            }
            RectanglePainter.paint((Graphics2D)g, (int)x, (int)y, (int)width, (int)height, (int)arc, (Paint)fill, (Paint)draw);
        }
    }

    static final class Track
    extends ScrollBarPainter {
        private final MixedColorProducer fillProducer;

        Track(@NotNull Supplier<? extends Component> supplier) {
            super(supplier);
            this.fillProducer = new MixedColorProducer(Track.getColor(supplier, TRACK_BACKGROUND, TRACK_OPAQUE_BACKGROUND), Track.getColor(supplier, TRACK_HOVERED_BACKGROUND, TRACK_OPAQUE_HOVERED_BACKGROUND));
        }

        public void paint(Graphics2D g, int x, int y, int width, int height, @Nullable Float value) {
            double mixer = value == null ? 0.0 : value.doubleValue();
            Color fill = this.fillProducer.produce(mixer);
            if (0 >= fill.getAlpha()) {
                return;
            }
            g.setPaint(fill);
            RectanglePainter.FILL.paint(g, x, y, width, height, null);
        }
    }
}

