/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SelectionAwareListCellRenderer<T>
extends DefaultListCellRenderer {
    private final NotNullFunction<? super T, ? extends JComponent> myFun;

    public SelectionAwareListCellRenderer(NotNullFunction<? super T, ? extends JComponent> fun) {
        this.myFun = fun;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList list, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
        JComponent comp = (JComponent)this.myFun.fun(value);
        comp.setOpaque(true);
        if (isSelected) {
            comp.setBackground(list.getSelectionBackground());
            comp.setForeground(list.getSelectionForeground());
        } else {
            comp.setBackground(list.getBackground());
            comp.setForeground(list.getForeground());
        }
        for (JLabel label : UIUtil.findComponentsOfType((JComponent)comp, JLabel.class)) {
            label.setForeground(UIUtil.getListForeground((boolean)isSelected));
        }
        return comp;
    }
}

