/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Expandable;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class ExpandableTextField
extends ExtendableTextField
implements Expandable {
    private final ExpandableSupport support;

    public ExpandableTextField() {
        this((Function<? super String, ? extends List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<? super List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public ExpandableTextField(@NotNull Function<? super String, ? extends List<String>> parser, @NotNull Function<? super List<String>, String> joiner) {
        Function onShow = text -> StringUtil.join((Collection)((Collection)parser.fun(text)), (String)"\n");
        Function onHide = text -> (String)joiner.fun(Arrays.asList(StringUtil.splitByLines((String)text)));
        this.support = new ExpandableSupport<JTextComponent>((JTextComponent)this, onShow, onHide){

            @Override
            @NotNull
            protected ExpandableSupport.Content prepare(final @NotNull JTextComponent field, @NotNull Function<? super String, String> onShow) {
                Font font = field.getFont();
                FontMetrics metrics = font == null ? null : field.getFontMetrics(font);
                int height = metrics == null ? 16 : metrics.getHeight();
                Dimension size = new Dimension(height * 32, height * 16);
                final JTextArea area = new JTextArea((String)onShow.fun((Object)field.getText()));
                area.putClientProperty(Expandable.class, this);
                area.setEditable(field.isEditable());
                area.setBackground(field.getBackground());
                area.setForeground(field.getForeground());
                area.setFont(font);
                area.setWrapStyleWord(true);
                area.setLineWrap(true);
                ExpandableTextField.copyCaretPosition(field, area);
                UIUtil.addUndoRedoActions((JTextComponent)area);
                JLabel label = 1.createLabel(this.createCollapseExtension());
                label.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
                final JBScrollPane pane = new JBScrollPane(area);
                pane.setVerticalScrollBarPolicy(22);
                pane.getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", label);
                pane.getVerticalScrollBar().setBackground(area.getBackground());
                Insets insets = field.getInsets();
                Insets margin = field.getMargin();
                if (margin != null) {
                    insets.top += margin.top;
                    insets.left += margin.left;
                    insets.right += margin.right;
                    insets.bottom += margin.bottom;
                }
                JBInsets.addTo((Dimension)size, (Insets)insets);
                JBInsets.addTo((Dimension)size, (Insets)pane.getInsets());
                pane.setPreferredSize(size);
                pane.setViewportBorder(insets != null ? BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right) : BorderFactory.createEmptyBorder());
                return new ExpandableSupport.Content(){

                    @Override
                    @NotNull
                    public JComponent getContentComponent() {
                        return pane;
                    }

                    @Override
                    public JComponent getFocusableComponent() {
                        return area;
                    }

                    @Override
                    public void cancel(@NotNull Function<? super String, String> onHide) {
                        if (field.isEditable()) {
                            field.setText((String)onHide.fun((Object)area.getText()));
                            ExpandableTextField.copyCaretPosition(area, field);
                        }
                    }
                };
            }
        };
        this.putClientProperty("monospaced", true);
        this.setExtensions(this.createExtensions());
    }

    @NotNull
    protected List<ExtendableTextComponent.Extension> createExtensions() {
        return Collections.singletonList(this.support.createExpandExtension());
    }

    public String getTitle() {
        return this.support.getTitle();
    }

    public void setTitle(String title) {
        this.support.setTitle(title);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.support.collapse();
        }
        super.setEnabled(enabled);
    }

    @Override
    public void collapse() {
        this.support.collapse();
    }

    @Override
    public boolean isExpanded() {
        return this.support.isExpanded();
    }

    @Override
    public void expand() {
        this.support.expand();
    }

    private static void copyCaretPosition(JTextComponent source, JTextComponent destination) {
        try {
            destination.setCaretPosition(source.getCaretPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

