/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractValueEditor<T>
implements ValueEditor<T> {
    @NotNull
    private T myDefaultValue;
    @Nullable
    private String myValueName;
    private final List<ValueEditor.Listener<T>> myListeners = new ArrayList<ValueEditor.Listener<T>>();

    protected AbstractValueEditor(@Nullable String valueName, @NotNull T defaultValue) {
        this.myDefaultValue = defaultValue;
        this.myValueName = valueName;
    }

    @Override
    @NotNull
    public T getValue() {
        try {
            return this.parseValue(this.getValueText());
        }
        catch (InvalidDataException ex) {
            return this.getDefaultValue();
        }
    }

    public void setValueName(@Nullable String valueName) {
        this.myValueName = valueName;
    }

    @Override
    @Nullable
    public String getValueName() {
        return this.myValueName;
    }

    @Override
    public void setValue(@NotNull T newValue) {
        if (!newValue.equals(this.getDefaultValue()) && !this.isValid(newValue)) {
            newValue = this.getDefaultValue();
        }
        this.setValueText(this.valueToString(newValue));
    }

    @Override
    public void validateContent() throws ConfigurationException {
        try {
            this.parseValue(this.getValueText());
        }
        catch (InvalidDataException ex) {
            String name = this.getValueName();
            throw new ConfigurationException((name != null ? name + " " : "") + ex.getMessage());
        }
    }

    @Override
    public void setDefaultValue(@NotNull T defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    @Override
    @NotNull
    public T getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    public void addListener(@NotNull ValueEditor.Listener<T> editorListener) {
        this.myListeners.add(editorListener);
    }

    public void fireValueChanged(@NotNull T newValue) {
        for (ValueEditor.Listener<T> listener : this.myListeners) {
            listener.valueChanged(newValue);
        }
    }
}

