/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerValueEditor
extends TextFieldValueEditor<Integer> {
    private int myMinValue;
    private int myMaxValue;
    private boolean myCanBeEmpty;

    public IntegerValueEditor(@NotNull JTextField field, @Nullable String valueName, @NotNull Integer defaultValue) {
        super(field, valueName, defaultValue);
    }

    @Override
    @NotNull
    public Integer parseValue(@Nullable String text) throws InvalidDataException {
        try {
            if (StringUtil.isEmpty((String)text)) {
                if (!this.myCanBeEmpty) {
                    throw new InvalidDataException(ApplicationBundle.message("integer.field.value.expected", new Object[0]));
                }
                return (Integer)this.getDefaultValue();
            }
            int value = Integer.parseInt(text);
            if (value < this.myMinValue || value > this.myMaxValue) {
                throw new InvalidDataException(ApplicationBundle.message("integer.field.value.out.of.range", value, this.myMinValue, this.myMaxValue));
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            throw new InvalidDataException(ApplicationBundle.message("integer.field.value.not.a.number", text));
        }
    }

    @Override
    public String valueToString(@NotNull Integer value) {
        if (this.myCanBeEmpty && value.equals(this.getDefaultValue())) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public boolean isValid(@NotNull Integer value) {
        return value >= this.myMinValue && value <= this.myMaxValue;
    }

    public int getMinValue() {
        return this.myMinValue;
    }

    public int getMaxValue() {
        return this.myMaxValue;
    }

    public void setMinValue(int minValue) {
        this.myMinValue = minValue;
    }

    public void setMaxValue(int maxValue) {
        this.myMaxValue = maxValue;
    }

    public boolean isCanBeEmpty() {
        return this.myCanBeEmpty;
    }

    public void setCanBeEmpty(boolean canBeEmpty) {
        this.myCanBeEmpty = canBeEmpty;
    }
}

