/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking;

import com.intellij.openapi.Disposable;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ui.update.Activatable;
import java.awt.Image;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DockContainer
extends Disposable,
Activatable {
    public RelativeRectangle getAcceptArea();

    public RelativeRectangle getAcceptAreaFallback();

    @NotNull
    public ContentResponse getContentResponse(@NotNull DockableContent var1, RelativePoint var2);

    public JComponent getContainerComponent();

    public void add(@NotNull DockableContent var1, RelativePoint var2);

    public void closeAll();

    public void addListener(Listener var1, Disposable var2);

    public boolean isEmpty();

    @Nullable
    public Image startDropOver(@NotNull DockableContent var1, RelativePoint var2);

    @Nullable
    public Image processDropOver(@NotNull DockableContent var1, RelativePoint var2);

    public void resetDropOver(@NotNull DockableContent var1);

    public boolean isDisposeWhenEmpty();

    public static interface Listener {
        public void contentAdded(@NotNull Object var1);

        public void contentRemoved(Object var1);

        public static class Adapter
        implements Listener {
            @Override
            public void contentAdded(@NotNull Object key) {
            }

            @Override
            public void contentRemoved(Object key) {
            }
        }
    }

    public static interface Persistent
    extends DockContainer {
        public String getDockContainerType();

        public Element getState();
    }

    public static interface Dialog
    extends DockContainer {
    }

    public static enum ContentResponse {
        ACCEPT_MOVE,
        ACCEPT_COPY,
        DENY;


        public boolean canAccept() {
            return this != DENY;
        }
    }
}

