/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.ListUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class FilteringListModel<T>
extends AbstractListModel<T> {
    private final ListModel<T> myOriginalModel;
    private final List<T> myData = new ArrayList<T>();
    private Condition<? super T> myCondition = null;
    private final ListDataListener myListDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }
    };

    public FilteringListModel(ListModel<T> originalModel) {
        this.myOriginalModel = originalModel;
        this.myOriginalModel.addListDataListener(this.myListDataListener);
    }

    public void dispose() {
        this.myOriginalModel.removeListDataListener(this.myListDataListener);
    }

    public void setFilter(Condition<? super T> condition) {
        this.myCondition = condition;
        this.refilter();
    }

    private void removeAllElements() {
        int index1 = this.myData.size() - 1;
        if (index1 >= 0) {
            this.myData.clear();
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void refilter() {
        this.removeAllElements();
        int count = 0;
        for (int i = 0; i < this.myOriginalModel.getSize(); ++i) {
            T elt = this.myOriginalModel.getElementAt(i);
            if (!this.passElement(elt)) continue;
            this.addToFiltered(elt);
            ++count;
        }
        if (count > 0) {
            this.fireIntervalAdded(this, 0, count - 1);
        }
    }

    protected void addToFiltered(T elt) {
        this.myData.add(elt);
    }

    @Override
    public int getSize() {
        return this.myData.size();
    }

    @Override
    public T getElementAt(int index2) {
        return this.myData.get(index2);
    }

    public int getElementIndex(T element) {
        return this.myData.indexOf(element);
    }

    private boolean passElement(T element) {
        return this.myCondition == null || this.myCondition.value(element);
    }

    public boolean contains(T value) {
        return this.myData.contains(value);
    }

    @NotNull
    public ListModel<T> getOriginalModel() {
        return this.myOriginalModel;
    }

    public void addAll(List<T> elements) {
        ListUtil.addAllItems(this.myOriginalModel, elements);
    }

    public void replaceAll(List<T> elements) {
        this.myData.clear();
        ListUtil.removeAllItems(this.myOriginalModel);
        ListUtil.addAllItems(this.myOriginalModel, elements);
    }

    public void remove(int index2) {
        ListUtil.removeItem(this.myOriginalModel, index2);
    }
}

