/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleTreeStructure
extends AbstractTreeStructure {
    @Override
    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        return ((SimpleNode)element).getChildren();
    }

    @Override
    public Object getParentElement(@NotNull Object element) {
        return ((SimpleNode)element).getParent();
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull Object element) {
        return ((SimpleNode)element).isAlwaysLeaf();
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        return (NodeDescriptor)element;
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean hasSomethingToCommit() {
        return false;
    }

    public final void clearCaches() {
        this.cleanUpCaches((SimpleNode)this.getRootElement());
    }

    private void cleanUpCaches(SimpleNode node) {
        if (!(node instanceof CachingSimpleNode)) {
            return;
        }
        CachingSimpleNode cachingNode = (CachingSimpleNode)node;
        if (cachingNode.getCached() == null) {
            return;
        }
        for (SimpleNode eachChild : cachingNode.myChildren) {
            this.cleanUpCaches(eachChild);
        }
        cachingNode.cleanUpCache();
    }

    public static class Impl
    extends SimpleTreeStructure {
        private final SimpleNode myRoot;

        public Impl(SimpleNode root) {
            this.myRoot = root;
        }

        @Override
        @NotNull
        public Object getRootElement() {
            return this.myRoot;
        }
    }
}

