/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellEditor;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModelAdapter;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeTable
extends JBTable {
    private static final Logger LOG = Logger.getInstance(TreeTable.class);
    private TreeTableTree myTree;
    private TreeTableModel myTableModel;
    private PropertyChangeListener myTreeRowHeightPropertyListener;
    private boolean myProcessCursorKeys = !ScreenReader.isActive();

    public TreeTable(TreeTableModel treeTableModel) {
        this.setModel(treeTableModel);
        new TreeAction("selectPreviousColumn", "selectParent");
        new TreeAction("selectPreviousColumnExtendSelection", "selectParentExtendSelection");
        new TreeAction("selectNextColumn", "selectChild");
        new TreeAction("selectNextColumnExtendSelection", "selectChildExtendSelection");
    }

    public void setModel(TreeTableModel treeTableModel) {
        if (this.myTree != null) {
            this.myTree.removePropertyChangeListener("rowHeight", this.myTreeRowHeightPropertyListener);
        }
        this.myTree = new TreeTableTree(treeTableModel, this);
        this.setRowHeight(this.myTree.getRowHeight());
        this.myTreeRowHeightPropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int treeRowHeight = TreeTable.this.myTree.getRowHeight();
                if (treeRowHeight == TreeTable.this.getRowHeight()) {
                    return;
                }
                TreeTable.this.setRowHeight(treeRowHeight);
            }
        };
        this.myTree.addPropertyChangeListener("rowHeight", this.myTreeRowHeightPropertyListener);
        this.setTableModel(treeTableModel);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.myTree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        TreeTableCellRenderer treeTableCellRenderer = this.createTableRenderer(treeTableModel);
        this.setDefaultRenderer(TreeTableModel.class, treeTableCellRenderer);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(treeTableCellRenderer));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.myTree.getRowHeight() < 1) {
            this.setRowHeight(JBUI.scale((int)18));
        } else {
            this.setRowHeight(this.getRowHeight());
        }
    }

    public TreeTableModel getTableModel() {
        return this.myTableModel;
    }

    public void setTableModel(TreeTableModel treeTableModel) {
        this.myTableModel = treeTableModel;
        super.setModel(this.adapt(treeTableModel));
    }

    protected TreeTableModelAdapter adapt(TreeTableModel treeTableModel) {
        return new TreeTableModelAdapter(treeTableModel, this.myTree, this);
    }

    public void setRootVisible(boolean visible) {
        this.myTree.setRootVisible(visible);
    }

    public void putTreeClientProperty(Object key, Object value) {
        this.myTree.putClientProperty(key, value);
    }

    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.myTree.setCellRenderer(renderer);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myTree != null) {
            this.myTree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.editingColumn == -1 || this.isTreeColumn(this.editingColumn) ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.myTree != null && this.myTree.getRowHeight() < rowHeight) {
            this.myTree.setRowHeight(this.getRowHeight());
        }
    }

    public TreeTableTree getTree() {
        return this.myTree;
    }

    public void setProcessCursorKeys(boolean processCursorKeys) {
        this.myProcessCursorKeys = processCursorKeys;
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean editResult = super.editCellAt(row, column, e);
        if (e instanceof MouseEvent && this.isTreeColumn(column)) {
            MouseEvent me = (MouseEvent)e;
            int y = me.getY();
            if (this.getRowHeight() != this.myTree.getRowHeight()) {
                Rectangle tableCellRect = this.getCellRect(row, column, true);
                y = Math.min(y - tableCellRect.y, this.myTree.getRowHeight() - 1) + row * this.myTree.getRowHeight();
            }
            MouseEvent newEvent = new MouseEvent(this.myTree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)column, (boolean)true).x, y, me.getClickCount(), me.isPopupTrigger());
            this.myTree.dispatchEvent(newEvent);
            if (newEvent.getID() == 501) {
                MouseEvent newME2 = new MouseEvent(this.myTree, 502, me.getWhen(), me.getModifiers(), me.getX() - this.getCellRect((int)0, (int)column, (boolean)true).x, y - this.getCellRect((int)0, (int)column, (boolean)true).y, me.getClickCount(), me.isPopupTrigger());
                this.myTree.dispatchEvent(newME2);
            }
        }
        return editResult;
    }

    protected boolean isTreeColumn(int column) {
        return TreeTableModel.class.isAssignableFrom(this.getColumnClass(column));
    }

    public void addSelectedPath(TreePath path2) {
        int row = this.getTree().getRowForPath(path2);
        this.getTree().addSelectionPath(path2);
        this.getSelectionModel().addSelectionInterval(row, row);
    }

    public void removeSelectedPath(TreePath path2) {
        int row = this.getTree().getRowForPath(path2);
        this.getTree().removeSelectionPath(path2);
        this.getSelectionModel().removeSelectionInterval(row, row);
    }

    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        return new TreeTableCellRenderer(this, this.myTree);
    }

    public void setMinRowHeight(int i) {
        this.setRowHeight(Math.max(this.getRowHeight(), i));
    }

    private class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    HashSet<Integer> selectedRows = new HashSet<Integer>();
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            if (!this.listSelectionModel.isSelectedIndex(counter)) continue;
                            selectedRows.add(new Integer(counter));
                        }
                    }
                    super.resetRowSelection();
                    this.listSelectionModel.clearSelection();
                    for (Object e : selectedRows) {
                        Integer row = (Integer)e;
                        this.listSelectionModel.addSelectionInterval(row, row);
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = TreeTable.this.myTree.getPathForRow(counter)) == null) continue;
                            selectionPaths.add(selPath);
                        }
                        if (!selectionPaths.isEmpty()) {
                            this.addSelectionPaths(selectionPaths.toArray(new TreePath[0]));
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    private final class TreeAction
    extends AbstractAction
    implements UIResource {
        private final String actionId;
        private final Action action;

        private TreeAction(@NotNull String tableActionId, String treeActionId) {
            super(tableActionId + " -> " + treeActionId);
            this.actionId = treeActionId;
            ActionMap map = TreeTable.this.getActionMap();
            this.action = map.get(tableActionId);
            if (!(this.action instanceof TreeAction)) {
                map.put(tableActionId, this);
            }
        }

        private JTree getTreeToPerformAction() {
            TreeTableTree tree;
            TreeTableTree treeTableTree = tree = !TreeTable.this.myProcessCursorKeys ? null : TreeTable.this.getTree();
            if (tree == null || 1 != TreeTable.this.getSelectedRowCount()) {
                return null;
            }
            if (!TreeTable.this.getColumnModel().getColumnSelectionAllowed()) {
                return tree;
            }
            int column = TreeTable.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            return 0 <= column && column < TreeTable.this.getColumnCount() && !TreeTable.this.isTreeColumn(column) ? null : tree;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Action action;
            JTree tree = this.getTreeToPerformAction();
            Action action2 = action = tree == null ? null : tree.getActionMap().get(this.actionId);
            if (action == null) {
                this.action.actionPerformed(event);
            } else {
                action.actionPerformed(new ActionEvent(tree, 1001, this.actionId));
                int row = tree.getLeadSelectionRow();
                TreeTable.this.getSelectionModel().setSelectionInterval(row, row);
                TableUtil.scrollSelectionToVisible((JTable)TreeTable.this);
            }
        }
    }
}

