/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usages.UsageViewPresentation;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesProcessPresentation {
    private final UsageViewPresentation myUsageViewPresentation;
    private boolean myShowPanelIfOnlyOneUsage;
    private boolean myShowNotFoundMessage;
    private Factory<ProgressIndicator> myProgressIndicatorFactory;
    private Collection<VirtualFile> myLargeFiles;
    private boolean myShowFindOptionsPrompt = true;
    private volatile Runnable mySearchWithProjectFiles;
    private volatile boolean myCanceled;

    public FindUsagesProcessPresentation(@NotNull UsageViewPresentation presentation) {
        this.myUsageViewPresentation = presentation;
    }

    public boolean isShowNotFoundMessage() {
        return this.myShowNotFoundMessage;
    }

    public void setShowNotFoundMessage(boolean showNotFoundMessage) {
        this.myShowNotFoundMessage = showNotFoundMessage;
    }

    public boolean isShowPanelIfOnlyOneUsage() {
        return this.myShowPanelIfOnlyOneUsage;
    }

    public void setShowPanelIfOnlyOneUsage(boolean showPanelIfOnlyOneUsage) {
        this.myShowPanelIfOnlyOneUsage = showPanelIfOnlyOneUsage;
    }

    public Factory<ProgressIndicator> getProgressIndicatorFactory() {
        return this.myProgressIndicatorFactory;
    }

    public void setProgressIndicatorFactory(@NotNull Factory<ProgressIndicator> progressIndicatorFactory) {
        this.myProgressIndicatorFactory = progressIndicatorFactory;
    }

    @Nullable
    public Runnable searchIncludingProjectFileUsages() {
        return this.mySearchWithProjectFiles;
    }

    public void projectFileUsagesFound(@NotNull Runnable searchWithProjectFiles) {
        this.mySearchWithProjectFiles = searchWithProjectFiles;
    }

    public void setLargeFilesWereNotScanned(@NotNull Collection<VirtualFile> largeFiles) {
        this.myLargeFiles = largeFiles;
    }

    @NotNull
    public Collection<VirtualFile> getLargeFiles() {
        return this.myLargeFiles == null ? Collections.emptyList() : this.myLargeFiles;
    }

    public boolean isShowFindOptionsPrompt() {
        return this.myShowFindOptionsPrompt;
    }

    @NotNull
    public UsageViewPresentation getUsageViewPresentation() {
        return this.myUsageViewPresentation;
    }

    public void setShowFindOptionsPrompt(boolean showFindOptionsPrompt) {
        this.myShowFindOptionsPrompt = showFindOptionsPrompt;
    }

    public void setCanceled(boolean canceled) {
        this.myCanceled = canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }
}

