/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.ide.SelectInEditorManager;
import com.intellij.ide.TypePresentationService;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.reference.SoftReference;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.RenameableUsage;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.awt.Point;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageInfo2UsageAdapter
implements UsageInModule,
UsageInLibrary,
UsageInFile,
PsiElementUsage,
MergeableUsage,
Comparable<UsageInfo2UsageAdapter>,
RenameableUsage,
TypeSafeDataProvider,
UsagePresentation {
    public static final NotNullFunction<UsageInfo, Usage> CONVERTER = UsageInfo2UsageAdapter::new;
    private static final Comparator<UsageInfo> BY_NAVIGATION_OFFSET = Comparator.comparingInt(UsageInfo::getNavigationOffset);
    private final UsageInfo myUsageInfo;
    @NotNull
    private Object myMergedUsageInfos;
    private final int myLineNumber;
    private final int myOffset;
    protected Icon myIcon;
    private volatile Reference<TextChunk[]> myTextChunks;
    private volatile UsageType myUsageType;
    private long myModificationStamp;

    public UsageInfo2UsageAdapter(@NotNull UsageInfo usageInfo) {
        this.myUsageInfo = usageInfo;
        this.myMergedUsageInfos = usageInfo;
        Point data = (Point)ReadAction.compute(() -> {
            int lineNumber;
            int offset;
            Document document;
            PsiElement element = this.getElement();
            PsiFile psiFile = usageInfo.getFile();
            boolean isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
            Document document2 = document = isNullOrBinary ? null : PsiDocumentManager.getInstance(this.getProject()).getDocument(psiFile);
            if (document == null) {
                offset = element == null || isNullOrBinary ? 0 : element.getTextOffset();
                lineNumber = -1;
            } else {
                int startOffset = this.myUsageInfo.getNavigationOffset();
                if (startOffset == -1) {
                    offset = element == null ? 0 : element.getTextOffset();
                    lineNumber = -1;
                } else {
                    offset = -1;
                    lineNumber = UsageInfo2UsageAdapter.getLineNumber(document, startOffset);
                }
            }
            return new Point(offset, lineNumber);
        });
        this.myOffset = data.x;
        this.myLineNumber = data.y;
        this.myModificationStamp = this.getCurrentModificationStamp();
    }

    private static int getLineNumber(@NotNull Document document, int startOffset) {
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (startOffset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(startOffset);
    }

    @NotNull
    private TextChunk[] initChunks() {
        TextChunk[] chunks;
        VirtualFile file = this.getFile();
        boolean isNullOrBinary = file == null || file.getFileType().isBinary();
        PsiElement element = this.getElement();
        if (element != null && isNullOrBinary) {
            EditorColorsScheme scheme = UsageTreeColorsScheme.getInstance().getScheme();
            chunks = new TextChunk[]{new TextChunk(scheme.getAttributes(DefaultLanguageHighlighterColors.CLASS_NAME), UsageInfo2UsageAdapter.clsType(element)), new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), " "), new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), UsageInfo2UsageAdapter.clsName(element))};
        } else {
            Document document;
            PsiFile psiFile = this.getPsiFile();
            Document document2 = document = psiFile == null ? null : PsiDocumentManager.getInstance(this.getProject()).getDocument(psiFile);
            chunks = document == null ? (element == null ? new TextChunk[]{new TextChunk(SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes(), UsageViewBundle.message("node.invalid", new Object[0]))} : new TextChunk[]{new TextChunk(new TextAttributes(), element.getText())}) : ChunkExtractor.extractChunks(psiFile, this);
        }
        this.myTextChunks = new SoftReference((Object)chunks);
        return chunks;
    }

    @Override
    @NotNull
    public UsagePresentation getPresentation() {
        return this;
    }

    @Override
    public boolean isValid() {
        PsiElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        for (UsageInfo usageInfo : this.getMergedInfos()) {
            if (!usageInfo.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadOnly() {
        PsiFile psiFile = this.getPsiFile();
        return psiFile == null || psiFile.isValid() && !psiFile.isWritable();
    }

    @Override
    @Nullable
    public FileEditorLocation getLocation() {
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null) {
            return null;
        }
        FileEditor editor = FileEditorManager.getInstance(this.getProject()).getSelectedEditor(virtualFile2);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        Segment segment = this.getUsageInfo().getSegment();
        if (segment == null) {
            return null;
        }
        return new TextEditorLocation(segment.getStartOffset(), (TextEditor)editor);
    }

    @Override
    public void selectInEditor() {
        if (!this.isValid()) {
            return;
        }
        Editor editor = this.openTextEditor(true);
        Segment marker = this.getFirstSegment();
        if (marker != null) {
            editor.getSelectionModel().setSelection(marker.getStartOffset(), marker.getEndOffset());
        }
    }

    @Override
    public void highlightInEditor() {
        if (!this.isValid()) {
            return;
        }
        Segment marker = this.getFirstSegment();
        if (marker != null) {
            SelectInEditorManager.getInstance(this.getProject()).selectInEditor(this.getFile(), marker.getStartOffset(), marker.getEndOffset(), false, false);
        }
    }

    private Segment getFirstSegment() {
        return this.getUsageInfo().getSegment();
    }

    public boolean processRangeMarkers(@NotNull Processor<? super Segment> processor) {
        for (UsageInfo usageInfo : this.getMergedInfos()) {
            Segment segment = usageInfo.getSegment();
            if (segment == null || processor.process((Object)segment)) continue;
            return false;
        }
        return true;
    }

    public Document getDocument() {
        PsiFile file = this.getUsageInfo().getFile();
        if (file == null) {
            return null;
        }
        return PsiDocumentManager.getInstance(this.getProject()).getDocument(file);
    }

    @Override
    public void navigate(boolean focus) {
        if (this.canNavigate()) {
            this.openTextEditor(focus);
        }
    }

    public Editor openTextEditor(boolean focus) {
        return FileEditorManager.getInstance(this.getProject()).openTextEditor(this.getDescriptor(), focus);
    }

    @Override
    public boolean canNavigate() {
        VirtualFile file = this.getFile();
        return file != null && file.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    private OpenFileDescriptor getDescriptor() {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        Segment range = this.getNavigationRange();
        if (range != null && file instanceof VirtualFileWindow && range.getStartOffset() >= 0) {
            range = ((VirtualFileWindow)((Object)file)).getDocumentWindow().injectedToHost(TextRange.create((Segment)range));
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        return new OpenFileDescriptor(this.getProject(), file, range == null ? this.getNavigationOffset() : range.getStartOffset());
    }

    int getNavigationOffset() {
        Document document = this.getDocument();
        if (document == null) {
            return -1;
        }
        int offset = this.getUsageInfo().getNavigationOffset();
        if (offset == -1) {
            offset = this.myOffset;
        }
        if (offset >= document.getTextLength()) {
            int line = Math.max(0, Math.min(this.myLineNumber, document.getLineCount() - 1));
            offset = document.getLineStartOffset(line);
        }
        return offset;
    }

    public Segment getNavigationRange() {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        Segment range = this.getUsageInfo().getNavigationRange();
        if (range == null) {
            ProperTextRange rangeInElement = this.getUsageInfo().getRangeInElement();
            Object object = this.myOffset < 0 ? new UnfairTextRange(-1, -1) : (range = rangeInElement == null ? TextRange.from((int)this.myOffset, (int)1) : rangeInElement.shiftRight(this.myOffset));
        }
        if (range.getEndOffset() >= document.getTextLength()) {
            int line = Math.max(0, Math.min(this.myLineNumber, document.getLineCount() - 1));
            range = TextRange.from((int)document.getLineStartOffset(line), (int)1);
        }
        return range;
    }

    @NotNull
    private Project getProject() {
        return this.getUsageInfo().getProject();
    }

    public String toString() {
        TextChunk[] textChunks = this.getPresentation().getText();
        StringBuilder result2 = new StringBuilder();
        for (int j = 0; j < textChunks.length; ++j) {
            if (j > 0) {
                result2.append("|");
            }
            TextChunk textChunk = textChunks[j];
            result2.append(textChunk);
        }
        return result2.toString();
    }

    @Override
    public Module getModule() {
        if (!this.isValid()) {
            return null;
        }
        VirtualFile virtualFile2 = this.getFile();
        return virtualFile2 != null ? ProjectFileIndex.getInstance(this.getProject()).getModuleForFile(virtualFile2) : null;
    }

    @Override
    public OrderEntry getLibraryEntry() {
        if (!this.isValid()) {
            return null;
        }
        PsiFile psiFile = this.getPsiFile();
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(this.getProject());
        if (virtualFile2.getFileType().isBinary() || fileIndex.isInLibrarySource(virtualFile2)) {
            List<OrderEntry> orders = fileIndex.getOrderEntriesForFile(virtualFile2);
            for (OrderEntry order : orders) {
                if (!(order instanceof LibraryOrderEntry) && !(order instanceof JdkOrderEntry)) continue;
                return order;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<SyntheticLibrary> getSyntheticLibraries() {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null) {
            return Collections.emptyList();
        }
        Project project = this.getProject();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(project);
        if (!fileIndex.isInLibrarySource(virtualFile2)) {
            return Collections.emptyList();
        }
        VirtualFile sourcesRoot = fileIndex.getSourceRootForFile(virtualFile2);
        if (sourcesRoot != null) {
            ArrayList<SyntheticLibrary> list = new ArrayList<SyntheticLibrary>();
            for (AdditionalLibraryRootsProvider e : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                for (SyntheticLibrary library : e.getAdditionalProjectLibraries(project)) {
                    Condition excludeFileCondition;
                    if (!library.getSourceRoots().contains(sourcesRoot) || (excludeFileCondition = library.getExcludeFileCondition()) != null && excludeFileCondition.value((Object)virtualFile2)) continue;
                    list.add(library);
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public VirtualFile getFile() {
        return this.getUsageInfo().getVirtualFile();
    }

    private PsiFile getPsiFile() {
        return this.getUsageInfo().getFile();
    }

    public int getLine() {
        return this.myLineNumber;
    }

    @Override
    public boolean merge(@NotNull MergeableUsage other) {
        if (!(other instanceof UsageInfo2UsageAdapter)) {
            return false;
        }
        UsageInfo2UsageAdapter u2 = (UsageInfo2UsageAdapter)other;
        assert (u2 != this);
        if (this.myLineNumber != u2.myLineNumber || !Comparing.equal((Object)this.getFile(), (Object)u2.getFile())) {
            return false;
        }
        UsageInfo[] merged = (UsageInfo[])ArrayUtil.mergeArrays((Object[])this.getMergedInfos(), (Object[])u2.getMergedInfos());
        this.myMergedUsageInfos = merged.length == 1 ? merged[0] : merged;
        Arrays.sort(this.getMergedInfos(), BY_NAVIGATION_OFFSET);
        this.myTextChunks = null;
        return true;
    }

    @Override
    public void reset() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myMergedUsageInfos = this.myUsageInfo;
        this.initChunks();
    }

    @Override
    public final PsiElement getElement() {
        return this.getUsageInfo().getElement();
    }

    @Override
    public boolean isNonCodeUsage() {
        return this.getUsageInfo().isNonCodeUsage;
    }

    @NotNull
    public UsageInfo getUsageInfo() {
        return this.myUsageInfo;
    }

    @Override
    public int compareTo(@NotNull UsageInfo2UsageAdapter o) {
        return this.getUsageInfo().compareToByStartOffset(o.getUsageInfo());
    }

    @Override
    public void rename(@NotNull String newName) throws IncorrectOperationException {
        PsiReference reference = this.getUsageInfo().getReference();
        assert (reference != null) : this;
        reference.handleElementRename(newName);
    }

    @NotNull
    public static UsageInfo2UsageAdapter[] convert(@NotNull UsageInfo[] usageInfos) {
        UsageInfo2UsageAdapter[] result2 = new UsageInfo2UsageAdapter[usageInfos.length];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = new UsageInfo2UsageAdapter(usageInfos[i]);
        }
        return result2;
    }

    @Override
    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (key == UsageView.USAGE_INFO_KEY) {
            sink.put(UsageView.USAGE_INFO_KEY, this.getUsageInfo());
        }
        if (key == UsageView.USAGE_INFO_LIST_KEY) {
            List<UsageInfo> list = Arrays.asList(this.getMergedInfos());
            sink.put(UsageView.USAGE_INFO_LIST_KEY, list);
        }
    }

    @NotNull
    public UsageInfo[] getMergedInfos() {
        UsageInfo[] usageInfoArray;
        Object infos = this.myMergedUsageInfos;
        if (infos instanceof UsageInfo) {
            UsageInfo[] usageInfoArray2 = new UsageInfo[1];
            usageInfoArray = usageInfoArray2;
            usageInfoArray2[0] = (UsageInfo)infos;
        } else {
            usageInfoArray = (UsageInfo[])infos;
        }
        return usageInfoArray;
    }

    private long getCurrentModificationStamp() {
        PsiFile containingFile = this.getPsiFile();
        return containingFile == null ? -1L : containingFile.getViewProvider().getModificationStamp();
    }

    @Override
    @NotNull
    public TextChunk[] getText() {
        return this.doUpdateCachedText();
    }

    @Override
    @Nullable
    public TextChunk[] getCachedText() {
        return (TextChunk[])SoftReference.dereference(this.myTextChunks);
    }

    @Override
    public void updateCachedText() {
        this.doUpdateCachedText();
    }

    @NotNull
    private TextChunk[] doUpdateCachedText() {
        boolean isModified;
        TextChunk[] chunks = (TextChunk[])SoftReference.dereference(this.myTextChunks);
        long currentModificationStamp = this.getCurrentModificationStamp();
        boolean bl = isModified = currentModificationStamp != this.myModificationStamp;
        if (chunks == null || this.isValid() && isModified) {
            chunks = this.initChunks();
            this.myModificationStamp = currentModificationStamp;
        }
        return chunks;
    }

    @NotNull
    private static String clsType(@NotNull PsiElement psiElement) {
        String type = LanguageFindUsages.getType(psiElement);
        if (!type.isEmpty()) {
            return type;
        }
        return (String)ObjectUtils.notNull((Object)TypePresentationService.getService().getTypePresentableName(psiElement.getClass()), (Object)"");
    }

    @NotNull
    private static String clsName(@NotNull PsiElement psiElement) {
        String name = LanguageFindUsages.getNodeText(psiElement, false);
        if (!name.isEmpty()) {
            return name;
        }
        return (String)ObjectUtils.notNull((Object)(psiElement instanceof PsiNamedElement ? ((PsiNamedElement)psiElement).getName() : null), (Object)"");
    }

    @Override
    @NotNull
    public String getPlainText() {
        Document document;
        int startOffset;
        boolean isNullOrBinary;
        PsiElement element = this.getElement();
        VirtualFile file = this.getFile();
        boolean bl = isNullOrBinary = file == null || file.getFileType().isBinary();
        if (element != null && isNullOrBinary) {
            return UsageInfo2UsageAdapter.clsType(element) + " " + UsageInfo2UsageAdapter.clsName(element);
        }
        if (element != null && (startOffset = this.getNavigationOffset()) != -1 && (document = this.getDocument()) != null) {
            int lineNumber = document.getLineNumber(startOffset);
            int lineStart = document.getLineStartOffset(lineNumber);
            int lineEnd = document.getLineEndOffset(lineNumber);
            String prefixSuffix = null;
            if (lineEnd - lineStart > 200) {
                prefixSuffix = "...";
                lineStart = Math.max(startOffset - 1, lineStart);
                lineEnd = Math.min(startOffset + 1, lineEnd);
            }
            String s = document.getCharsSequence().subSequence(lineStart, lineEnd).toString();
            if (prefixSuffix != null) {
                s = prefixSuffix + s + prefixSuffix;
            }
            return s;
        }
        return UsageViewBundle.message("node.invalid", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            PsiElement psiElement = this.getElement();
            icon = psiElement != null && psiElement.isValid() && !this.isFindInPathUsage(psiElement) ? psiElement.getIcon(0) : null;
            this.myIcon = icon;
        }
        return icon;
    }

    private boolean isFindInPathUsage(PsiElement psiElement) {
        return psiElement instanceof PsiFile && this.getUsageInfo().getPsiFileRange() != null;
    }

    @Override
    public String getTooltipText() {
        return this.myUsageInfo.getTooltipText();
    }

    @Nullable
    public UsageType getUsageType() {
        UsageType usageType = this.myUsageType;
        if (usageType == null) {
            Document document;
            Segment segment;
            usageType = UsageType.UNCLASSIFIED;
            PsiFile file = this.getPsiFile();
            if (file != null && !file.getFileType().isBinary() && (segment = this.getFirstSegment()) != null && (document = PsiDocumentManager.getInstance(this.getProject()).getDocument(file)) != null) {
                ChunkExtractor extractor = ChunkExtractor.getExtractor(file);
                SmartList chunks = new SmartList();
                extractor.createTextChunks(this, document.getCharsSequence(), segment.getStartOffset(), segment.getEndOffset(), false, (List<? super TextChunk>)chunks);
                for (TextChunk chunk : chunks) {
                    UsageType chunkUsageType = chunk.getType();
                    if (chunkUsageType == null) continue;
                    usageType = chunkUsageType;
                    break;
                }
            }
            this.myUsageType = usageType;
        }
        return usageType;
    }
}

