/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public abstract class UsageInfoSearcherAdapter
implements UsageSearcher {
    protected void processUsages(@NotNull Processor<? super Usage> processor, @NotNull Project project) {
        Usage[] usages;
        Ref refUsages = new Ref();
        Ref dumbModeOccurred = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            try {
                refUsages.set((Object)this.findUsages());
            }
            catch (IndexNotReadyException e) {
                dumbModeOccurred.set((Object)true);
            }
        });
        if (!dumbModeOccurred.isNull()) {
            DumbService.getInstance(project).showDumbModeNotification("Usage search is not available until indices are ready");
            return;
        }
        for (Usage usage : usages = (Usage[])ReadAction.compute(() -> UsageInfo2UsageAdapter.convert((UsageInfo[])refUsages.get()))) {
            ApplicationManager.getApplication().runReadAction(() -> processor.process((Object)usage));
        }
    }

    @NotNull
    protected abstract UsageInfo[] findUsages();
}

