/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageTargetUtil {
    private static final ExtensionPointName<UsageTargetProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.usageTargetProvider");

    public static UsageTarget[] findUsageTargets(@NotNull DataProvider dataProvider) {
        UsageTarget[] targets;
        PsiElement psiElement;
        UsageTarget[] targets2;
        Editor editor = CommonDataKeys.EDITOR.getData(dataProvider);
        PsiFile file = CommonDataKeys.PSI_FILE.getData(dataProvider);
        ArrayList result2 = new ArrayList();
        if (file != null && editor != null && (targets2 = UsageTargetUtil.findUsageTargets(editor, file)) != null) {
            Collections.addAll(result2, targets2);
        }
        if ((psiElement = CommonDataKeys.PSI_ELEMENT.getData(dataProvider)) != null && (targets = UsageTargetUtil.findUsageTargets(psiElement)) != null) {
            Collections.addAll(result2, targets);
        }
        return result2.isEmpty() ? null : result2.toArray(UsageTarget.EMPTY_ARRAY);
    }

    public static UsageTarget[] findUsageTargets(@NotNull Editor editor, @NotNull PsiFile file) {
        ArrayList result2 = new ArrayList();
        for (UsageTargetProvider provider : UsageTargetUtil.getProviders(file.getProject())) {
            UsageTarget[] targets = provider.getTargets(editor, file);
            if (targets == null) continue;
            Collections.addAll(result2, targets);
        }
        return result2.isEmpty() ? null : result2.toArray(UsageTarget.EMPTY_ARRAY);
    }

    public static UsageTarget[] findUsageTargets(@NotNull PsiElement psiElement) {
        ArrayList result2 = new ArrayList();
        for (UsageTargetProvider provider : UsageTargetUtil.getProviders(psiElement.getProject())) {
            UsageTarget[] targets = provider.getTargets(psiElement);
            if (targets == null) continue;
            Collections.addAll(result2, targets);
        }
        return result2.isEmpty() ? null : result2.toArray(UsageTarget.EMPTY_ARRAY);
    }

    @NotNull
    private static List<UsageTargetProvider> getProviders(@NotNull Project project) {
        return DumbService.getDumbAwareExtensions(project, EP_NAME);
    }
}

