/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.util.Comparing;
import com.intellij.usageView.UsageViewBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewPresentation {
    private String myTabText;
    private String myScopeText = "";
    private String myContextText = "";
    private String myUsagesString;
    private String myTargetsNodeText = UsageViewBundle.message("node.targets", new Object[0]);
    private String myNonCodeUsagesString = UsageViewBundle.message("node.non.code.usages", new Object[0]);
    private String myCodeUsagesString = UsageViewBundle.message("node.found.usages", new Object[0]);
    private String myUsagesInGeneratedCodeString = UsageViewBundle.message("node.usages.in.generated.code", new Object[0]);
    private boolean myShowReadOnlyStatusAsRed = false;
    private boolean myShowCancelButton = false;
    private boolean myOpenInNewTab = true;
    private boolean myCodeUsages = true;
    private boolean myUsageTypeFilteringAvailable;
    private String myUsagesWord = UsageViewBundle.message("usage.name", new Object[0]);
    private String myTabName;
    private String myToolwindowTitle;
    private boolean myDetachedMode;
    private String myDynamicCodeUsagesString;
    private boolean myMergeDupLinesAvailable = true;
    private boolean myExcludeAvailable = true;
    private Pattern mySearchPattern;
    private Pattern myReplacePattern;
    private boolean myReplaceMode;

    public String getTabText() {
        return this.myTabText;
    }

    public void setTabText(String tabText) {
        this.myTabText = tabText;
    }

    @NotNull
    public String getScopeText() {
        return this.myScopeText;
    }

    public void setScopeText(@NotNull String scopeText) {
        this.myScopeText = scopeText;
    }

    @NotNull
    public String getContextText() {
        return this.myContextText;
    }

    public void setContextText(@NotNull String contextText) {
        this.myContextText = contextText;
    }

    public boolean isShowReadOnlyStatusAsRed() {
        return this.myShowReadOnlyStatusAsRed;
    }

    public void setShowReadOnlyStatusAsRed(boolean showReadOnlyStatusAsRed) {
        this.myShowReadOnlyStatusAsRed = showReadOnlyStatusAsRed;
    }

    public String getUsagesString() {
        return this.myUsagesString;
    }

    public void setUsagesString(String usagesString) {
        this.myUsagesString = usagesString;
    }

    @Nullable(value="null means the targets node must not be visible")
    public String getTargetsNodeText() {
        return this.myTargetsNodeText;
    }

    public void setTargetsNodeText(String targetsNodeText) {
        this.myTargetsNodeText = targetsNodeText;
    }

    public boolean isShowCancelButton() {
        return this.myShowCancelButton;
    }

    public void setShowCancelButton(boolean showCancelButton) {
        this.myShowCancelButton = showCancelButton;
    }

    @NotNull
    public String getNonCodeUsagesString() {
        return this.myNonCodeUsagesString;
    }

    public void setNonCodeUsagesString(@NotNull String nonCodeUsagesString) {
        this.myNonCodeUsagesString = nonCodeUsagesString;
    }

    @NotNull
    public String getCodeUsagesString() {
        return this.myCodeUsagesString;
    }

    public void setCodeUsagesString(@NotNull String codeUsagesString) {
        this.myCodeUsagesString = codeUsagesString;
    }

    public boolean isOpenInNewTab() {
        return this.myOpenInNewTab;
    }

    public void setOpenInNewTab(boolean openInNewTab) {
        this.myOpenInNewTab = openInNewTab;
    }

    public boolean isCodeUsages() {
        return this.myCodeUsages;
    }

    public void setCodeUsages(boolean codeUsages) {
        this.myCodeUsages = codeUsages;
    }

    @NotNull
    public String getUsagesWord() {
        return this.myUsagesWord;
    }

    public void setUsagesWord(@NotNull String usagesWord) {
        this.myUsagesWord = usagesWord;
    }

    public String getTabName() {
        return this.myTabName;
    }

    public void setTabName(String tabName) {
        this.myTabName = tabName;
    }

    public String getToolwindowTitle() {
        return this.myToolwindowTitle;
    }

    public void setToolwindowTitle(String toolwindowTitle) {
        this.myToolwindowTitle = toolwindowTitle;
    }

    public boolean isDetachedMode() {
        return this.myDetachedMode;
    }

    public void setDetachedMode(boolean detachedMode) {
        this.myDetachedMode = detachedMode;
    }

    public void setDynamicUsagesString(String dynamicCodeUsagesString) {
        this.myDynamicCodeUsagesString = dynamicCodeUsagesString;
    }

    public String getDynamicCodeUsagesString() {
        return this.myDynamicCodeUsagesString;
    }

    @NotNull
    public String getUsagesInGeneratedCodeString() {
        return this.myUsagesInGeneratedCodeString;
    }

    public void setUsagesInGeneratedCodeString(@NotNull String usagesInGeneratedCodeString) {
        this.myUsagesInGeneratedCodeString = usagesInGeneratedCodeString;
    }

    public boolean isMergeDupLinesAvailable() {
        return this.myMergeDupLinesAvailable;
    }

    public void setMergeDupLinesAvailable(boolean mergeDupLinesAvailable) {
        this.myMergeDupLinesAvailable = mergeDupLinesAvailable;
    }

    public boolean isUsageTypeFilteringAvailable() {
        return this.myCodeUsages || this.myUsageTypeFilteringAvailable;
    }

    public void setUsageTypeFilteringAvailable(boolean usageTypeFilteringAvailable) {
        this.myUsageTypeFilteringAvailable = usageTypeFilteringAvailable;
    }

    public boolean isExcludeAvailable() {
        return this.myExcludeAvailable;
    }

    public void setExcludeAvailable(boolean excludeAvailable) {
        this.myExcludeAvailable = excludeAvailable;
    }

    public void setSearchPattern(Pattern searchPattern) {
        this.mySearchPattern = searchPattern;
    }

    public Pattern getSearchPattern() {
        return this.mySearchPattern;
    }

    public void setReplacePattern(Pattern replacePattern) {
        this.myReplacePattern = replacePattern;
    }

    public Pattern getReplacePattern() {
        return this.myReplacePattern;
    }

    public boolean isReplaceMode() {
        return this.myReplaceMode;
    }

    public void setReplaceMode(boolean replaceMode) {
        this.myReplaceMode = replaceMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UsageViewPresentation)) {
            return false;
        }
        UsageViewPresentation that = (UsageViewPresentation)o;
        if (this.myCodeUsages != that.myCodeUsages) {
            return false;
        }
        if (this.myDetachedMode != that.myDetachedMode) {
            return false;
        }
        if (this.myMergeDupLinesAvailable != that.myMergeDupLinesAvailable) {
            return false;
        }
        if (this.myOpenInNewTab != that.myOpenInNewTab) {
            return false;
        }
        if (this.myShowCancelButton != that.myShowCancelButton) {
            return false;
        }
        if (this.myShowReadOnlyStatusAsRed != that.myShowReadOnlyStatusAsRed) {
            return false;
        }
        if (this.myUsageTypeFilteringAvailable != that.myUsageTypeFilteringAvailable) {
            return false;
        }
        if (this.myExcludeAvailable != that.myExcludeAvailable) {
            return false;
        }
        if (this.myCodeUsagesString != null ? !this.myCodeUsagesString.equals(that.myCodeUsagesString) : that.myCodeUsagesString != null) {
            return false;
        }
        if (this.myDynamicCodeUsagesString != null ? !this.myDynamicCodeUsagesString.equals(that.myDynamicCodeUsagesString) : that.myDynamicCodeUsagesString != null) {
            return false;
        }
        if (this.myNonCodeUsagesString != null ? !this.myNonCodeUsagesString.equals(that.myNonCodeUsagesString) : that.myNonCodeUsagesString != null) {
            return false;
        }
        if (this.myScopeText != null ? !this.myScopeText.equals(that.myScopeText) : that.myScopeText != null) {
            return false;
        }
        if (this.myTabName != null ? !this.myTabName.equals(that.myTabName) : that.myTabName != null) {
            return false;
        }
        if (this.myTabText != null ? !this.myTabText.equals(that.myTabText) : that.myTabText != null) {
            return false;
        }
        if (this.myTargetsNodeText != null ? !this.myTargetsNodeText.equals(that.myTargetsNodeText) : that.myTargetsNodeText != null) {
            return false;
        }
        if (this.myToolwindowTitle != null ? !this.myToolwindowTitle.equals(that.myToolwindowTitle) : that.myToolwindowTitle != null) {
            return false;
        }
        if (this.myUsagesInGeneratedCodeString != null ? !this.myUsagesInGeneratedCodeString.equals(that.myUsagesInGeneratedCodeString) : that.myUsagesInGeneratedCodeString != null) {
            return false;
        }
        if (this.myUsagesString != null ? !this.myUsagesString.equals(that.myUsagesString) : that.myUsagesString != null) {
            return false;
        }
        if (this.myUsagesWord != null ? !this.myUsagesWord.equals(that.myUsagesWord) : that.myUsagesWord != null) {
            return false;
        }
        if (!UsageViewPresentation.arePatternsEqual(this.mySearchPattern, that.mySearchPattern)) {
            return false;
        }
        return UsageViewPresentation.arePatternsEqual(this.myReplacePattern, that.myReplacePattern);
    }

    public static boolean arePatternsEqual(Pattern p1, Pattern p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return Comparing.equal((String)p1.pattern(), (String)p2.pattern()) && p1.flags() == p2.flags();
    }

    public static int getHashCode(Pattern pattern) {
        if (pattern == null) {
            return 0;
        }
        String s = pattern.pattern();
        return (s != null ? s.hashCode() : 0) * 31 + pattern.flags();
    }

    public int hashCode() {
        int result2 = this.myTabText != null ? this.myTabText.hashCode() : 0;
        result2 = 31 * result2 + (this.myScopeText != null ? this.myScopeText.hashCode() : 0);
        result2 = 31 * result2 + (this.myUsagesString != null ? this.myUsagesString.hashCode() : 0);
        result2 = 31 * result2 + (this.myTargetsNodeText != null ? this.myTargetsNodeText.hashCode() : 0);
        result2 = 31 * result2 + (this.myNonCodeUsagesString != null ? this.myNonCodeUsagesString.hashCode() : 0);
        result2 = 31 * result2 + (this.myCodeUsagesString != null ? this.myCodeUsagesString.hashCode() : 0);
        result2 = 31 * result2 + (this.myUsagesInGeneratedCodeString != null ? this.myUsagesInGeneratedCodeString.hashCode() : 0);
        result2 = 31 * result2 + (this.myShowReadOnlyStatusAsRed ? 1 : 0);
        result2 = 31 * result2 + (this.myShowCancelButton ? 1 : 0);
        result2 = 31 * result2 + (this.myOpenInNewTab ? 1 : 0);
        result2 = 31 * result2 + (this.myCodeUsages ? 1 : 0);
        result2 = 31 * result2 + (this.myUsageTypeFilteringAvailable ? 1 : 0);
        result2 = 31 * result2 + (this.myExcludeAvailable ? 1 : 0);
        result2 = 31 * result2 + (this.myUsagesWord != null ? this.myUsagesWord.hashCode() : 0);
        result2 = 31 * result2 + UsageViewPresentation.getHashCode(this.mySearchPattern);
        result2 = 31 * result2 + UsageViewPresentation.getHashCode(this.myReplacePattern);
        result2 = 31 * result2 + (this.myTabName != null ? this.myTabName.hashCode() : 0);
        result2 = 31 * result2 + (this.myToolwindowTitle != null ? this.myToolwindowTitle.hashCode() : 0);
        result2 = 31 * result2 + (this.myDetachedMode ? 1 : 0);
        result2 = 31 * result2 + (this.myDynamicCodeUsagesString != null ? this.myDynamicCodeUsagesString.hashCode() : 0);
        result2 = 31 * result2 + (this.myMergeDupLinesAvailable ? 1 : 0);
        return result2;
    }

    public UsageViewPresentation copy() {
        UsageViewPresentation copyInstance = new UsageViewPresentation();
        copyInstance.myTabText = this.myTabText;
        copyInstance.myScopeText = this.myScopeText;
        copyInstance.myContextText = this.myContextText;
        copyInstance.myUsagesString = this.myUsagesString;
        copyInstance.myTargetsNodeText = this.myTargetsNodeText;
        copyInstance.myNonCodeUsagesString = this.myNonCodeUsagesString;
        copyInstance.myCodeUsagesString = this.myCodeUsagesString;
        copyInstance.myUsagesInGeneratedCodeString = this.myUsagesInGeneratedCodeString;
        copyInstance.myShowReadOnlyStatusAsRed = this.myShowReadOnlyStatusAsRed;
        copyInstance.myShowCancelButton = this.myShowCancelButton;
        copyInstance.myOpenInNewTab = this.myOpenInNewTab;
        copyInstance.myCodeUsages = this.myCodeUsages;
        copyInstance.myUsageTypeFilteringAvailable = this.myUsageTypeFilteringAvailable;
        copyInstance.myUsagesWord = this.myUsagesWord;
        copyInstance.myTabName = this.myTabName;
        copyInstance.myToolwindowTitle = this.myToolwindowTitle;
        copyInstance.myDetachedMode = this.myDetachedMode;
        copyInstance.myDynamicCodeUsagesString = this.myDynamicCodeUsagesString;
        copyInstance.myMergeDupLinesAvailable = this.myMergeDupLinesAvailable;
        copyInstance.myExcludeAvailable = this.myExcludeAvailable;
        copyInstance.mySearchPattern = this.mySearchPattern;
        copyInstance.myReplacePattern = this.myReplacePattern;
        copyInstance.myReplaceMode = this.myReplaceMode;
        return copyInstance;
    }
}

