/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SearchForUsagesRunnable
implements Runnable {
    @NonNls
    private static final String FIND_OPTIONS_HREF_TARGET = "FindOptions";
    @NonNls
    private static final String SEARCH_IN_PROJECT_HREF_TARGET = "SearchInProject";
    @NonNls
    private static final String LARGE_FILES_HREF_TARGET = "LargeFiles";
    @NonNls
    private static final String SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET = "SHOW_PROJECT_FILE_OCCURRENCES";
    private final AtomicInteger myUsageCountWithoutDefinition = new AtomicInteger(0);
    private final AtomicReference<Usage> myFirstUsage = new AtomicReference();
    @NotNull
    private final Project myProject;
    private final AtomicReference<UsageViewEx> myUsageViewRef;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] mySearchFor;
    private final Factory<UsageSearcher> mySearcherFactory;
    private final FindUsagesProcessPresentation myProcessPresentation;
    @NotNull
    private final SearchScope mySearchScopeToWarnOfFallingOutOf;
    private final UsageViewManager.UsageViewStateListener myListener;
    private final UsageViewManagerImpl myUsageViewManager;
    private final AtomicInteger myOutOfScopeUsages = new AtomicInteger();

    SearchForUsagesRunnable(@NotNull UsageViewManagerImpl usageViewManager, @NotNull Project project, @NotNull AtomicReference<UsageViewEx> usageViewRef, @NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull SearchScope searchScopeToWarnOfFallingOutOf, @Nullable UsageViewManager.UsageViewStateListener listener) {
        this.myProject = project;
        this.myUsageViewRef = usageViewRef;
        this.myPresentation = presentation;
        this.mySearchFor = searchFor;
        this.mySearcherFactory = searcherFactory;
        this.myProcessPresentation = processPresentation;
        this.mySearchScopeToWarnOfFallingOutOf = searchScopeToWarnOfFallingOutOf;
        this.myListener = listener;
        this.myUsageViewManager = usageViewManager;
    }

    @NotNull
    private static String createOptionsHtml(@NonNls @NotNull UsageTarget[] searchFor) {
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut(searchFor);
        String shortcutText = "";
        if (shortcut != null) {
            shortcutText = "&nbsp;(" + KeymapUtil.getShortcutText(shortcut) + ")";
        }
        return "<a href='FindOptions'>Find Options...</a>" + shortcutText;
    }

    @NotNull
    private static String createSearchInProjectHtml() {
        return "<a href='SearchInProject'>Search in Project</a>";
    }

    private void notifyByFindBalloon(@Nullable HyperlinkListener listener, @NotNull MessageType messageType, @NotNull List<String> lines) {
        Runnable searchIncludingProjectFileUsages;
        UsageViewContentManager.getInstance(this.myProject);
        Collection<VirtualFile> largeFiles = this.myProcessPresentation.getLargeFiles();
        ArrayList<String> resultLines = new ArrayList<String>(lines);
        HyperlinkListener resultListener = listener;
        if (!largeFiles.isEmpty()) {
            String shortMessage = "(<a href='LargeFiles'>" + UsageViewBundle.message("large.files.were.ignored", largeFiles.size()) + "</a>)";
            resultLines.add(shortMessage);
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, LARGE_FILES_HREF_TARGET, () -> {
                String detailedMessage = SearchForUsagesRunnable.detailedLargeFilesMessage(largeFiles);
                ArrayList<String> strings = new ArrayList<String>(lines);
                strings.add(detailedMessage);
                ToolWindowManager.getInstance(this.myProject).notifyByBalloon(ToolWindowId.FIND, messageType, SearchForUsagesRunnable.wrapInHtml(strings), AllIcons.Actions.Find, listener);
            });
        }
        if ((searchIncludingProjectFileUsages = this.myProcessPresentation.searchIncludingProjectFileUsages()) != null) {
            resultLines.add("Occurrences in project configuration files are skipped. <a href='SHOW_PROJECT_FILE_OCCURRENCES'>Include them</a>");
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET, searchIncludingProjectFileUsages);
        }
        Collection<UnloadedModuleDescription> unloaded = this.getUnloadedModulesBelongingToScope();
        MessageType actualType = messageType;
        if (!unloaded.isEmpty()) {
            if (actualType == MessageType.INFO) {
                actualType = MessageType.WARNING;
            }
            resultLines.add(SearchForUsagesRunnable.mayHaveUsagesInUnloadedModulesMessage(unloaded));
        }
        ToolWindowManager.getInstance(this.myProject).notifyByBalloon(ToolWindowId.FIND, actualType, SearchForUsagesRunnable.wrapInHtml(resultLines), AllIcons.Actions.Find, resultListener);
    }

    @NotNull
    private Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        return (Collection)ReadAction.compute(() -> {
            if (!(this.mySearchScopeToWarnOfFallingOutOf instanceof GlobalSearchScope)) {
                return Collections.emptySet();
            }
            Collection<UnloadedModuleDescription> unloadedInSearchScope = ((GlobalSearchScope)this.mySearchScopeToWarnOfFallingOutOf).getUnloadedModulesBelongingToScope();
            Set<UnloadedModuleDescription> unloadedInUseScope = this.getUnloadedModulesBelongingToUseScopes();
            if (unloadedInUseScope != null) {
                return ContainerUtil.intersection(unloadedInSearchScope, unloadedInUseScope);
            }
            return unloadedInSearchScope;
        });
    }

    private Set<UnloadedModuleDescription> getUnloadedModulesBelongingToUseScopes() {
        LinkedHashSet<UnloadedModuleDescription> resolveScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (UsageTarget target : this.mySearchFor) {
            if (!(target instanceof PsiElementUsageTarget)) {
                return null;
            }
            PsiElement element = ((PsiElementUsageTarget)target).getElement();
            if (element == null) {
                return null;
            }
            SearchScope useScope = element.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            resolveScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return resolveScope;
    }

    @NotNull
    private static HyperlinkListener addHrefHandling(final @Nullable HyperlinkListener listener, final @NotNull String hrefTarget, final @NotNull Runnable handler) {
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(hrefTarget)) {
                    handler.run();
                } else if (listener != null) {
                    listener.hyperlinkUpdate(e);
                }
            }
        };
    }

    @NotNull
    private static String wrapInHtml(@NotNull List<String> strings) {
        return XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(strings, (String)"<br>"));
    }

    @NotNull
    private static String detailedLargeFilesMessage(@NotNull Collection<? extends VirtualFile> largeFiles) {
        String message = "";
        if (largeFiles.size() == 1) {
            VirtualFile vFile = largeFiles.iterator().next();
            message = message + "File " + SearchForUsagesRunnable.presentableFileInfo(vFile) + " is ";
        } else {
            message = message + "Files<br> ";
            int counter = 0;
            for (VirtualFile virtualFile2 : largeFiles) {
                message = message + SearchForUsagesRunnable.presentableFileInfo(virtualFile2) + "<br> ";
                if (counter++ <= 10) continue;
                break;
            }
            message = message + "are ";
        }
        message = message + "too large and cannot be scanned";
        return message;
    }

    @NotNull
    private static String presentableFileInfo(@NotNull VirtualFile vFile) {
        return SearchForUsagesRunnable.getPresentablePath(vFile) + "&nbsp;(" + UsageViewManagerImpl.presentableSize(UsageViewManagerImpl.getFileLength(vFile)) + ")";
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile virtualFile2) {
        return "'" + (String)ReadAction.compute(virtualFile2::getPresentableUrl) + "'";
    }

    @NotNull
    private HyperlinkListener createGotToOptionsListener(final @NotNull UsageTarget[] targets) {
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getDescription().equals(SearchForUsagesRunnable.FIND_OPTIONS_HREF_TARGET)) {
                    TransactionGuard.getInstance().submitTransactionAndWait(() -> FindManager.getInstance(SearchForUsagesRunnable.this.myProject).showSettingsAndFindUsages(targets));
                }
            }
        };
    }

    @NotNull
    private HyperlinkListener createSearchInProjectListener() {
        return new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                PsiElement psiElement;
                if (e.getDescription().equals(SearchForUsagesRunnable.SEARCH_IN_PROJECT_HREF_TARGET) && (psiElement = SearchForUsagesRunnable.getPsiElement(SearchForUsagesRunnable.this.mySearchFor)) != null) {
                    TransactionGuard.getInstance().submitTransactionAndWait(() -> FindManager.getInstance(SearchForUsagesRunnable.this.myProject).findUsagesInScope(psiElement, GlobalSearchScope.projectScope(SearchForUsagesRunnable.this.myProject)));
                }
            }
        };
    }

    private static PsiElement getPsiElement(@NotNull UsageTarget[] searchFor) {
        UsageTarget target = searchFor[0];
        if (!(target instanceof PsiElementUsageTarget)) {
            return null;
        }
        return (PsiElement)ReadAction.compute(((PsiElementUsageTarget)target)::getElement);
    }

    private static void flashUsageScriptaculously(@NotNull Usage usage) {
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        Processor processor = Processors.cancelableCollectProcessor(segments);
        usageInfo.processRangeMarkers(processor);
        rangeBlinker.resetMarkers(segments);
        rangeBlinker.startBlinking();
    }

    private UsageViewEx getUsageView(@NotNull ProgressIndicator indicator) {
        UsageView usageView = this.myUsageViewRef.get();
        if (usageView != null) {
            return usageView;
        }
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount >= 2 || usageCount == 1 && this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            usageView = this.myUsageViewManager.createUsageView(this.mySearchFor, Usage.EMPTY_ARRAY, this.myPresentation, (Factory)this.mySearcherFactory);
            if (this.myUsageViewRef.compareAndSet(null, (UsageViewEx)usageView)) {
                usageView.associateProgress(indicator);
                if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                    this.openView((UsageViewEx)usageView);
                } else if (this.myListener != null) {
                    SwingUtilities.invokeLater(() -> {
                        UsageViewEx uv;
                        if (!this.myProject.isDisposed() && (uv = this.myUsageViewRef.get()) != null) {
                            this.myListener.usageViewCreated(uv);
                        }
                    });
                }
                Usage firstUsage = this.myFirstUsage.get();
                if (firstUsage != null) {
                    UsageView finalUsageView = usageView;
                    ApplicationManager.getApplication().runReadAction(() -> SearchForUsagesRunnable.lambda$getUsageView$3((UsageViewEx)finalUsageView, firstUsage));
                }
            } else {
                UsageView finalUsageView = usageView;
                UIUtil.invokeLaterIfNeeded(() -> SearchForUsagesRunnable.lambda$getUsageView$4((UsageViewEx)finalUsageView));
            }
            return this.myUsageViewRef.get();
        }
        return null;
    }

    private void openView(@NotNull UsageViewEx usageView) {
        SwingUtilities.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myUsageViewManager.showUsageView(usageView, this.myPresentation);
            if (this.myListener != null) {
                this.myListener.usageViewCreated(usageView);
            }
            this.myUsageViewManager.showToolWindow(false);
        });
    }

    @Override
    public void run() {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        AtomicBoolean findUsagesStartedShown = new AtomicBoolean();
        this.searchUsages(findUsagesStartedShown);
        this.endSearchForUsages(findUsagesStartedShown);
        snapshot.logResponsivenessSinceCreation("Find Usages");
    }

    private void searchUsages(@NotNull AtomicBoolean findStartedBalloonShown) {
        ProgressIndicator indicator = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        if (indicator == null) {
            throw new IllegalStateException("must run find usages under progress");
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            CoreProgressManager.assertUnderProgress((ProgressIndicator)indicator);
        }
        TooManyUsagesStatus.createFor((ProgressIndicator)indicator);
        Alarm findUsagesStartedBalloon = new Alarm();
        findUsagesStartedBalloon.addRequest(() -> {
            this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList(StringUtil.escapeXmlEntities((String)UsageViewManagerImpl.getProgressTitle(this.myPresentation))));
            findStartedBalloonShown.set(true);
        }, 300, ModalityState.NON_MODAL);
        UsageSearcher usageSearcher = (UsageSearcher)this.mySearcherFactory.create();
        usageSearcher.generate((Processor<Usage>)((Processor)usage -> {
            boolean incrementCounter;
            ProgressIndicator indicator1 = ProgressWrapper.unwrap((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            if (indicator1 == null) {
                throw new IllegalStateException("must run find usages under progress");
            }
            if (indicator1.isCanceled()) {
                return false;
            }
            if (!UsageViewManagerImpl.isInScope(usage, this.mySearchScopeToWarnOfFallingOutOf)) {
                this.myOutOfScopeUsages.incrementAndGet();
                return true;
            }
            boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, this.mySearchFor);
            if (incrementCounter) {
                int usageCount = this.myUsageCountWithoutDefinition.incrementAndGet();
                if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                    this.myFirstUsage.compareAndSet((Usage)null, (Usage)usage);
                }
                UsageViewEx usageView = this.getUsageView(indicator1);
                TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom((ProgressIndicator)indicator1);
                if (usageCount > 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                    UsageViewManagerImpl.showTooManyUsagesWarningLater(this.myProject, tooManyUsagesStatus, indicator1, this.myPresentation, usageCount, usageView);
                }
                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                if (usageView != null) {
                    ApplicationManager.getApplication().runReadAction(() -> usageView.appendUsage((Usage)usage));
                }
            }
            return !indicator1.isCanceled();
        }));
        if (this.getUsageView(indicator) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.myUsageViewManager.showToolWindow(true), this.myProject.getDisposed());
        }
        Disposer.dispose((Disposable)findUsagesStartedBalloon);
        ApplicationManager.getApplication().invokeLater(() -> {
            Balloon balloon;
            if (findStartedBalloonShown.get() && (balloon = ToolWindowManager.getInstance(this.myProject).getToolWindowBalloon(ToolWindowId.FIND)) != null) {
                balloon.hide();
            }
        }, this.myProject.getDisposed());
    }

    private void endSearchForUsages(@NotNull AtomicBoolean findStartedBalloonShown) {
        UsageViewEx usageView;
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount == 0) {
            if (this.myProcessPresentation.isShowNotFoundMessage()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myProcessPresentation.isCanceled()) {
                        this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList("Usage search was canceled"));
                        findStartedBalloonShown.set(false);
                        return;
                    }
                    String message = UsageViewBundle.message("dialog.no.usages.found.in", StringUtil.decapitalize((String)StringUtil.notNullize((String)this.myPresentation.getUsagesString())), this.myPresentation.getScopeText(), this.myPresentation.getContextText());
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add(StringUtil.escapeXmlEntities((String)message));
                    if (this.myOutOfScopeUsages.get() != 0) {
                        lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                    }
                    if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                        lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                    }
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines);
                    findStartedBalloonShown.set(false);
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Usage usage = this.myFirstUsage.get();
                if (usage.canNavigate()) {
                    usage.navigate(true);
                    SearchForUsagesRunnable.flashUsageScriptaculously(usage);
                }
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("Only one usage found.");
                if (this.myOutOfScopeUsages.get() != 0) {
                    lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                }
                lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines);
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            HyperlinkListener hyperlinkListener;
            List<Object> lines;
            usageView = this.myUsageViewRef.get();
            usageView.searchFinished();
            if (this.myOutOfScopeUsages.get() == 0 || SearchForUsagesRunnable.getPsiElement(this.mySearchFor) == null) {
                lines = Collections.emptyList();
                hyperlinkListener = null;
            } else {
                lines = Arrays.asList(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf), SearchForUsagesRunnable.createSearchInProjectHtml());
                hyperlinkListener = this.createSearchInProjectListener();
            }
            if (!this.myProcessPresentation.getLargeFiles().isEmpty() || this.myOutOfScopeUsages.get() != 0 || this.myProcessPresentation.searchIncludingProjectFileUsages() != null || !this.getUnloadedModulesBelongingToScope().isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(hyperlinkListener, type, lines);
                }, ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        }
        if ((usageView = this.myUsageViewRef.get()) != null) {
            usageView.waitForUpdateRequestsCompletion();
        }
        if (this.myListener != null) {
            this.myListener.findingUsagesFinished(usageView);
        }
    }

    @NotNull
    private static String mayHaveUsagesInUnloadedModulesMessage(@NotNull Collection<? extends UnloadedModuleDescription> unloadedModules) {
        String modulesText = unloadedModules.size() > 1 ? unloadedModules.size() + " unloaded modules" : "unloaded module '" + ((UnloadedModuleDescription)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(unloadedModules))).getName() + "'";
        return "Occurrences in " + modulesText + " may be skipped. Load all modules and repeat the search to get complete results.";
    }

    private static /* synthetic */ void lambda$getUsageView$4(UsageViewEx finalUsageView) {
        Disposer.dispose((Disposable)finalUsageView);
    }

    private static /* synthetic */ void lambda$getUsageView$3(UsageViewEx finalUsageView, Usage firstUsage) {
        finalUsageView.appendUsage(firstUsage);
    }
}

