/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageModelTracker
implements Disposable {
    private final List<UsageModelTrackerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public UsageModelTracker(@NotNull Project project) {
        PsiTreeChangeAdapter myPsiListener = new PsiTreeChangeAdapter(){

            @Override
            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, false);
            }

            @Override
            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                UsageModelTracker.this.doFire(event, true);
            }
        };
        PsiManager.getInstance(project).addPsiTreeChangeListener(myPsiListener, this);
    }

    private void doFire(@NotNull PsiTreeChangeEvent event, boolean propertyChange) {
        if (!(event.getFile() instanceof PsiCodeFragment)) {
            for (UsageModelTrackerListener listener : this.myListeners) {
                listener.modelChanged(propertyChange);
            }
        }
    }

    public void dispose() {
    }

    public void addListener(@NotNull UsageModelTrackerListener listener, @NotNull Disposable parent) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parent, () -> this.myListeners.remove(listener));
    }

    @FunctionalInterface
    public static interface UsageModelTrackerListener {
        public void modelChanged(boolean var1);
    }
}

