/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageGroupBase;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleGroupingRule
implements UsageGroupingRule,
DumbAware {
    private final ModuleGrouper myGrouper;
    private final boolean myFlattenModules;

    public ModuleGroupingRule(Project project, boolean flattenModules) {
        this.myGrouper = ModuleGrouper.instanceFor(project);
        this.myFlattenModules = flattenModules;
    }

    @Override
    @NotNull
    public List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        UsageInModule usageInModule;
        Module module;
        if (usage instanceof UsageInModule && (module = (usageInModule = (UsageInModule)usage).getModule()) != null) {
            if (this.myFlattenModules) {
                return Collections.singletonList(new ModuleUsageGroup(module, null));
            }
            List<String> groupPath = this.myGrouper.getGroupPath(module);
            ArrayList<UsageGroup> parentGroups = new ArrayList<UsageGroup>(groupPath.size() + 1);
            for (int i = 1; i <= groupPath.size(); ++i) {
                parentGroups.add(new ModuleGroupUsageGroup(groupPath.subList(0, i)));
            }
            parentGroups.add(new ModuleUsageGroup(module, this.myGrouper));
            return parentGroups;
        }
        if (usage instanceof UsageInLibrary) {
            UsageInLibrary usageInLibrary = (UsageInLibrary)usage;
            OrderEntry entry = usageInLibrary.getLibraryEntry();
            if (entry != null) {
                return Collections.singletonList(new LibraryUsageGroup(entry));
            }
            for (SyntheticLibrary syntheticLibrary : usageInLibrary.getSyntheticLibraries()) {
                if (!(syntheticLibrary instanceof ItemPresentation)) continue;
                return Collections.singletonList(new SyntheticLibraryUsageGroup((ItemPresentation)syntheticLibrary));
            }
        }
        return Collections.emptyList();
    }

    private static class ModuleGroupUsageGroup
    extends UsageGroupBase {
        private final List<String> myGroupPath;

        ModuleGroupUsageGroup(@NotNull List<String> groupPath) {
            super(0);
            this.myGroupPath = groupPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ModuleGroupUsageGroup && this.myGroupPath.equals(((ModuleGroupUsageGroup)o).myGroupPath);
        }

        public int hashCode() {
            return this.myGroupPath.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Nodes.ModuleGroup;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            return this.myGroupPath.get(this.myGroupPath.size() - 1);
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module.group", new Object[0]) + this.getText(null);
        }
    }

    private static class ModuleUsageGroup
    extends UsageGroupBase
    implements TypeSafeDataProvider {
        private final Module myModule;
        private final ModuleGrouper myGrouper;

        ModuleUsageGroup(@NotNull Module module, @Nullable ModuleGrouper grouper) {
            super(1);
            this.myModule = module;
            this.myGrouper = grouper;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleUsageGroup)) {
                return false;
            }
            ModuleUsageGroup moduleUsageGroup = (ModuleUsageGroup)o;
            return this.myModule.equals(moduleUsageGroup.myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myModule.isDisposed() ? null : ModuleType.get(this.myModule).getIcon();
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            return this.myModule.isDisposed() ? "" : (this.myGrouper != null ? this.myGrouper.getShortenedName(this.myModule) : this.myModule.getName());
        }

        @Override
        public boolean isValid() {
            return !this.myModule.isDisposed();
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module", new Object[0]) + this.getText(null);
        }

        @Override
        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.MODULE_CONTEXT == key) {
                sink.put(LangDataKeys.MODULE_CONTEXT, this.myModule);
            }
        }
    }

    private static class SyntheticLibraryUsageGroup
    extends UsageGroupBase {
        @NotNull
        private final ItemPresentation myItemPresentation;

        SyntheticLibraryUsageGroup(@NotNull ItemPresentation itemPresentation) {
            super(2);
            this.myItemPresentation = itemPresentation;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myItemPresentation.getIcon(false);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            return StringUtil.notNullize((String)this.myItemPresentation.getPresentableText(), (String)"Library");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof SyntheticLibraryUsageGroup && this.myItemPresentation.equals(((SyntheticLibraryUsageGroup)o).myItemPresentation);
        }

        public int hashCode() {
            return this.myItemPresentation.hashCode();
        }
    }

    private static class LibraryUsageGroup
    extends UsageGroupBase {
        private final OrderEntry myEntry;

        LibraryUsageGroup(@NotNull OrderEntry entry) {
            super(2);
            this.myEntry = entry;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Nodes.PpLibFolder;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            return this.myEntry.getPresentableName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof LibraryUsageGroup && this.myEntry.equals(((LibraryUsageGroup)o).myEntry);
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }
    }
}

