/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public final class ExtensionInstantiator {
    private static final Logger LOG = Logger.getInstance(ExtensionInstantiator.class);

    private ExtensionInstantiator() {
    }

    @NotNull
    public static <T> T instantiateWithPicoContainerOnlyIfNeeded(@Nullable String className, @NotNull PicoContainer picoContainer, @Nullable PluginDescriptor pluginDescriptor) {
        Class clazz;
        PluginId pluginId;
        PluginId pluginId2 = pluginId = pluginDescriptor == null ? null : pluginDescriptor.getPluginId();
        if (className == null) {
            throw new PluginException("implementation class is not specified", pluginId);
        }
        try {
            clazz = AbstractExtensionPointBean.findClass((String)className, (PluginDescriptor)pluginDescriptor);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(e, pluginId);
        }
        try {
            return (T)ReflectionUtil.newInstance((Class)clazz, (boolean)false);
        }
        catch (ExtensionNotApplicableException | ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                PluginException exception = new PluginException("Bean extension class constructor must not have parameters: " + className, pluginId);
                Application app = ApplicationManager.getApplication();
                if (app != null && app.isUnitTestMode()) {
                    LOG.error((Throwable)exception);
                } else {
                    LOG.warn((Throwable)exception);
                }
            } else {
                throw new PluginException(e, pluginId);
            }
            try {
                return (T)AbstractExtensionPointBean.instantiate((Class)clazz, (PicoContainer)picoContainer, (boolean)true);
            }
            catch (ProcessCanceledException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new PluginException(e3, pluginId);
            }
        }
    }
}

