/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileContentUtilCore {
    @NonNls
    public static final String FORCE_RELOAD_REQUESTOR = "FileContentUtilCore.saveOrReload";

    public static void reparseFiles(VirtualFile ... files) {
        FileContentUtilCore.reparseFiles(Arrays.asList(files));
    }

    public static void reparseFiles(@NotNull Collection<? extends VirtualFile> files) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            THashSet events = new THashSet();
            for (VirtualFile file : files) {
                FileContentUtilCore.saveOrReload(file, (Collection<? super VFilePropertyChangeEvent>)events);
            }
            BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List eventList = Collections.unmodifiableList(new ArrayList(events));
            publisher.before(eventList);
            publisher.after(eventList);
        });
    }

    private static void saveOrReload(VirtualFile file, @NotNull Collection<? super VFilePropertyChangeEvent> events) {
        Document document;
        if (file == null || file.isDirectory() || !file.isValid()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(file) && (document = documentManager.getDocument(file)) != null) {
            documentManager.saveDocumentAsIs(document);
        }
        events.add(new VFilePropertyChangeEvent(FORCE_RELOAD_REQUESTOR, file, "name", file.getName(), file.getName(), false));
    }
}

