/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.CompositeIcon;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.FileIconKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Producer;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create((String)"iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = key -> {
        VirtualFile file = key.getFile();
        int flags = IconUtil.filterFileIconFlags(file, key.getFlags());
        Project project = key.getProject();
        if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
            return null;
        }
        Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
        Object icon = providersIcon != null ? providersIcon : IconUtil.getBaseIcon(file);
        boolean dumb = project != null && DumbService.getInstance(project).isDumb();
        for (FileIconPatcher patcher : IconUtil.getPatchers()) {
            if (dumb && !DumbService.isDumbAware(patcher)) continue;
            icon = patcher.patchIcon((Icon)icon, file, flags & 0xFFFFFFFD, project);
        }
        if (file.is(VFileProperty.SYMLINK)) {
            icon = new LayeredIcon(new Icon[]{icon, PlatformIcons.SYMLINK_ICON});
        }
        if (!(!BitUtil.isSet((int)flags, (int)2) || file.isWritable() && WritingAccessProvider.isPotentiallyWritable(file, project))) {
            icon = new LayeredIcon(new Icon[]{icon, PlatformIcons.LOCKED_ICON});
        }
        Iconable.LastComputedIcon.put((UserDataHolder)file, icon, flags);
        return icon;
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        Boolean was = (Boolean)project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, true);
            } else {
                was = false;
            }
        }
        return was;
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, int maxWidth, int maxHeight) {
        if (icon.getIconHeight() <= maxHeight && icon.getIconWidth() <= maxWidth) {
            return icon;
        }
        Image image = IconUtil.toImage(icon);
        if (image == null) {
            return icon;
        }
        double scale = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            scale = ((JBHiDPIScaledImage)image).getScale();
            image = ((JBHiDPIScaledImage)image).getDelegate();
        }
        BufferedImage bi = ImageUtil.toBufferedImage((Image)image);
        Graphics2D g = bi.createGraphics();
        int imageWidth = ImageUtil.getRealWidth((Image)image);
        int imageHeight = ImageUtil.getRealHeight((Image)image);
        maxWidth = maxWidth == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxWidth * scale);
        maxHeight = maxHeight == Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)Math.round((double)maxHeight * scale);
        int w = Math.min(imageWidth, maxWidth);
        int h = Math.min(imageHeight, maxHeight);
        BufferedImage img = UIUtil.createImage((Graphics)g, (int)w, (int)h, (int)3);
        int offX = imageWidth > maxWidth ? (imageWidth - maxWidth) / 2 : 0;
        int offY = imageHeight > maxHeight ? (imageHeight - maxHeight) / 2 : 0;
        for (int col = 0; col < w; ++col) {
            for (int row = 0; row < h; ++row) {
                img.setRGB(col, row, bi.getRGB(col + offX, row + offY));
            }
        }
        g.dispose();
        return new JBImageIcon(RetinaImage.createFrom((Image)img, (double)scale, null));
    }

    @NotNull
    public static Icon cropIcon(@NotNull Icon icon, @NotNull Rectangle area) {
        if (!new Rectangle(icon.getIconWidth(), icon.getIconHeight()).contains(area)) {
            return icon;
        }
        return new CropIcon(icon, area);
    }

    @NotNull
    public static Icon flip(final @NotNull Icon icon, final boolean horizontal) {
        return new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    AffineTransform transform = AffineTransform.getTranslateInstance(horizontal ? (double)(x + this.getIconWidth()) : (double)x, horizontal ? (double)y : (double)(y + this.getIconHeight()));
                    transform.concatenate(AffineTransform.getScaleInstance(horizontal ? -1.0 : 1.0, horizontal ? 1.0 : -1.0));
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    icon.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        };
    }

    @Iconable.IconFlags
    private static int filterFileIconFlags(VirtualFile file, @Iconable.IconFlags int flags) {
        UserDataHolder fileTypeDataHolder = (UserDataHolder)ObjectUtils.tryCast((Object)file.getFileType(), UserDataHolder.class);
        int fileTypeFlagIgnoreMask = (Integer)Iconable.ICON_FLAG_IGNORE_MASK.get(fileTypeDataHolder, (Object)0);
        int flagIgnoreMask = (Integer)Iconable.ICON_FLAG_IGNORE_MASK.get((UserDataHolder)file, (Object)fileTypeFlagIgnoreMask);
        return flags & ~flagIgnoreMask;
    }

    public static Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
        Icon lastIcon = Iconable.LastComputedIcon.get((UserDataHolder)file, flags);
        Icon base = lastIcon != null ? lastIcon : IconUtil.getBaseIcon(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), ICON_NULLABLE_FUNCTION);
    }

    private static Icon getBaseIcon(VirtualFile vFile) {
        Icon icon = TypePresentationService.getService().getIcon(vFile);
        if (icon != null) {
            return icon;
        }
        FileType fileType = vFile.getFileType();
        if (vFile.isDirectory() && vFile.isInLocalFileSystem() && !(fileType instanceof DirectoryFileType)) {
            return PlatformIcons.FOLDER_ICON;
        }
        return fileType.getIcon();
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, Project project) {
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    public static Icon getEmptyIcon(boolean showVisibility) {
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/class.png"), 0);
        if (showVisibility) {
            baseIcon.setIcon(IconUtil.createEmptyIconLike("/nodes/c_public.png"), 1);
        }
        return baseIcon;
    }

    @NotNull
    private static Icon createEmptyIconLike(@NotNull String baseIconPath) {
        Icon baseIcon = IconLoader.findIcon((String)baseIconPath);
        if (baseIcon == null) {
            return EmptyIcon.ICON_16;
        }
        return EmptyIcon.create((Icon)baseIcon);
    }

    @NotNull
    private static List<FileIconProvider> getProviders() {
        return FileIconProviderHolder.myProviders;
    }

    @NotNull
    private static List<FileIconPatcher> getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    public static Image toImage(@NotNull Icon icon) {
        return IconUtil.toImage(icon, null);
    }

    public static Image toImage(@NotNull Icon icon, @Nullable JBUI.ScaleContext ctx) {
        return IconLoader.toImage((Icon)icon, (JBUI.ScaleContext)ctx);
    }

    @NotNull
    public static Icon getAddIcon() {
        return AllIcons.General.Add;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        return AllIcons.General.Remove;
    }

    @NotNull
    public static Icon getMoveUpIcon() {
        return AllIcons.Actions.MoveUp;
    }

    @NotNull
    public static Icon getMoveDownIcon() {
        return AllIcons.Actions.MoveDown;
    }

    @NotNull
    public static Icon getEditIcon() {
        return AllIcons.Actions.Edit;
    }

    @NotNull
    public static Icon getAddClassIcon() {
        return AllIcons.ToolbarDecorator.AddClass;
    }

    @NotNull
    public static Icon getAddPatternIcon() {
        return AllIcons.ToolbarDecorator.AddPattern;
    }

    @NotNull
    public static Icon getAddJiraPatternIcon() {
        return AllIcons.ToolbarDecorator.AddJira;
    }

    @NotNull
    public static Icon getAddYouTrackPatternIcon() {
        return AllIcons.ToolbarDecorator.AddYouTrack;
    }

    @NotNull
    public static Icon getAddBlankLineIcon() {
        return AllIcons.ToolbarDecorator.AddBlankLine;
    }

    @NotNull
    public static Icon getAddPackageIcon() {
        return AllIcons.ToolbarDecorator.AddFolder;
    }

    @NotNull
    public static Icon getAddLinkIcon() {
        return AllIcons.ToolbarDecorator.AddLink;
    }

    @NotNull
    public static Icon getAddFolderIcon() {
        return AllIcons.ToolbarDecorator.AddFolder;
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        return IconUtil.getToolbarDecoratorIcon("analyze.png");
    }

    public static void paintInCenterOf(@NotNull Component c, @NotNull Graphics g, @NotNull Icon icon) {
        int x = (c.getWidth() - icon.getIconWidth()) / 2;
        int y = (c.getHeight() - icon.getIconHeight()) / 2;
        icon.paintIcon(c, g, x, y);
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name) {
        return IconLoader.getIcon((String)(IconUtil.getToolbarDecoratorIconsFolder() + name));
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        return "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
    }

    @NotNull
    public static Icon[] getEqualSizedIcons(Icon ... icons) {
        Icon[] result2 = new Icon[icons.length];
        int width = 0;
        int height = 0;
        for (Icon icon : icons) {
            width = Math.max(width, icon.getIconWidth());
            height = Math.max(height, icon.getIconHeight());
        }
        for (int i = 0; i < icons.length; ++i) {
            result2[i] = new IconSizeWrapper(icons[i], width, height);
        }
        return result2;
    }

    @NotNull
    public static Icon toSize(@Nullable Icon icon, int width, int height) {
        return new IconSizeWrapper(icon, width, height);
    }

    @Deprecated
    @NotNull
    public static Icon scale(final @NotNull Icon source, double _scale) {
        final double scale = Math.min(32.0, Math.max(0.1, _scale));
        return new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g.create();
                try {
                    g2d.translate(x, y);
                    AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
                    transform.preConcatenate(g2d.getTransform());
                    g2d.setTransform(transform);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    source.paintIcon(c, g2d, 0, 0);
                }
                finally {
                    g2d.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return (int)((double)source.getIconWidth() * scale);
            }

            @Override
            public int getIconHeight() {
                return (int)((double)source.getIconHeight() * scale);
            }
        };
    }

    @Contract(value="null, _->null; !null, _->!null")
    public static Icon copy(@Nullable Icon icon, @Nullable Component ancestor) {
        return IconLoader.copy((Icon)icon, (Component)ancestor);
    }

    @NotNull
    public static Icon scale(@NotNull Icon icon, @Nullable Component ancestor, float scale) {
        if (icon instanceof ScalableIcon) {
            if (icon instanceof JBUI.ScaleContextAware) {
                ((JBUI.ScaleContextAware)icon).updateScaleContext((JBUI.BaseScaleContext)(ancestor != null ? JBUI.ScaleContext.create((Component)ancestor) : null));
            }
            return ((ScalableIcon)icon).scale(scale);
        }
        return IconUtil.scale(icon, scale);
    }

    @NotNull
    public static Icon scaleByFont(@NotNull Icon icon, @Nullable Component ancestor, float fontSize) {
        float scale = JBUI.getFontScale((float)fontSize);
        if (icon instanceof JBUI.ScaleContextAware) {
            JBUI.ScaleContextAware ctxIcon = (JBUI.ScaleContextAware)icon;
            double usrScale = ctxIcon.getScaleContext().getScale(JBUI.ScaleType.USR_SCALE);
            scale = (float)((double)scale / usrScale);
        }
        return IconUtil.scale(icon, ancestor, scale);
    }

    @NotNull
    public static Icon overrideScale(@NotNull Icon icon, JBUI.Scale scale) {
        if (icon instanceof CompositeIcon) {
            CompositeIcon compositeIcon = (CompositeIcon)icon;
            for (int i = 0; i < compositeIcon.getIconCount(); ++i) {
                Icon subIcon = compositeIcon.getIcon(i);
                if (subIcon == null) continue;
                IconUtil.overrideScale(subIcon, scale);
            }
        }
        if (icon instanceof JBUI.ScaleContextAware) {
            ((JBUI.ScaleContextAware)icon).getScaleContext().overrideScale(scale);
        }
        return icon;
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color) {
        return IconUtil.colorize(source, color, false);
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        return IconUtil.colorize(g, source, color, false);
    }

    @NotNull
    public static Icon colorize(@NotNull Icon source, @NotNull Color color, boolean keepGray) {
        return IconUtil.filterIcon(null, source, new ColorFilter(color, keepGray));
    }

    @NotNull
    public static Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color, boolean keepGray) {
        return IconUtil.filterIcon(g, source, new ColorFilter(color, keepGray));
    }

    @Nullable
    public static Icon desaturate(@NotNull Icon source) {
        return IconUtil.filterIcon(source, (Producer<RGBImageFilter>)((Producer)() -> new DesaturationFilter()), null);
    }

    @Nullable
    public static Icon brighter(@NotNull Icon source, int tones) {
        return IconUtil.filterIcon(source, (Producer<RGBImageFilter>)((Producer)() -> new BrighterFilter(tones)), null);
    }

    @Nullable
    public static Icon darker(@NotNull Icon source, int tones) {
        return IconUtil.filterIcon(source, (Producer<RGBImageFilter>)((Producer)() -> new DarkerFilter(tones)), null);
    }

    @NotNull
    private static Icon filterIcon(Graphics2D g, @NotNull Icon source, @NotNull Filter filter) {
        BufferedImage src = g != null ? UIUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)3) : UIUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)3);
        Graphics2D g2d = src.createGraphics();
        source.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        BufferedImage img = g != null ? UIUtil.createImage((Graphics)g, (int)source.getIconWidth(), (int)source.getIconHeight(), (int)3) : UIUtil.createImage((int)source.getIconWidth(), (int)source.getIconHeight(), (int)3);
        int[] rgba = new int[4];
        for (int y = 0; y < src.getRaster().getHeight(); ++y) {
            for (int x = 0; x < src.getRaster().getWidth(); ++x) {
                src.getRaster().getPixel(x, y, rgba);
                if (rgba[3] == 0) continue;
                img.getRaster().setPixel(x, y, filter.convert(rgba));
            }
        }
        return IconUtil.createImageIcon((Image)img);
    }

    @Deprecated
    @NotNull
    public static JBImageIcon createImageIcon(@NotNull BufferedImage img) {
        return IconUtil.createImageIcon((Image)img);
    }

    @NotNull
    public static JBImageIcon createImageIcon(@NotNull Image img) {
        return new JBImageIcon(img){

            public int getIconWidth() {
                return ImageUtil.getUserWidth((Image)this.getImage());
            }

            public int getIconHeight() {
                return ImageUtil.getUserHeight((Image)this.getImage());
            }
        };
    }

    @NotNull
    public static Icon textToIcon(@NotNull String text, final @NotNull Component component, final float fontSize) {
        class MyIcon
        extends JBUI.ScalableJBIcon {
            @NotNull
            private final String myText;
            private Font myFont;
            private FontMetrics myMetrics;
            private final WeakReference<Component> myCompRef;

            MyIcon(@NotNull String text) {
                this.myCompRef = new WeakReference<Component>(component);
                this.myText = text;
                this.setIconPreScaled(false);
                this.getScaleContext().addUpdateListener(() -> this.update());
                this.update();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                try {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    g.setFont(this.myFont);
                    UIUtil.drawStringWithHighlighting((Graphics)g, (String)this.myText, (int)((int)this.scaleVal(x, JBUI.ScaleType.OBJ_SCALE) + (int)this.scaleVal(2.0)), (int)((int)this.scaleVal(y, JBUI.ScaleType.OBJ_SCALE) + this.getIconHeight() - (int)this.scaleVal(1.0)), (Color)JBColor.foreground(), (Color)JBColor.background());
                }
                finally {
                    g.dispose();
                }
            }

            public int getIconWidth() {
                return this.myMetrics.stringWidth(this.myText) + (int)this.scaleVal(4.0);
            }

            public int getIconHeight() {
                return this.myMetrics.getHeight();
            }

            private void update() {
                this.myFont = JBFont.create((Font)JBUI.Fonts.label().deriveFont((float)this.scaleVal(fontSize, JBUI.ScaleType.OBJ_SCALE)));
                Component comp = (Component)this.myCompRef.get();
                if (comp == null) {
                    comp = new Component(){};
                }
                this.myMetrics = comp.getFontMetrics(this.myFont);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof MyIcon)) {
                    return false;
                }
                MyIcon icon = (MyIcon)((Object)o);
                if (!Objects.equals(this.myText, icon.myText)) {
                    return false;
                }
                return Objects.equals(this.myFont, icon.myFont);
            }
        }
        return new MyIcon(text);
    }

    @NotNull
    public static Icon addText(@NotNull Icon base, @NotNull String text) {
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        icon.setIcon(IconUtil.textToIcon(text, new JLabel(), JBUI.scale((float)6.0f)), 1, 4);
        return icon;
    }

    @Nullable
    public static Icon filterIcon(@NotNull Icon icon, Producer<RGBImageFilter> filterSupplier, @Nullable Component ancestor) {
        return IconLoader.filterIcon((Icon)icon, filterSupplier, (Component)ancestor);
    }

    private static class DarkerFilter
    extends RGBImageFilter {
        private final int myTones;

        DarkerFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            Color originalColor = new Color(rgb, true);
            Color filteredColor = ColorUtil.toAlpha((Color)ColorUtil.darker((Color)originalColor, (int)this.myTones), (int)originalColor.getAlpha());
            return filteredColor.getRGB();
        }
    }

    private static class BrighterFilter
    extends RGBImageFilter {
        private final int myTones;

        BrighterFilter(int tones) {
            this.myTones = tones;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            Color originalColor = new Color(rgb, true);
            Color filteredColor = ColorUtil.toAlpha((Color)ColorUtil.brighter((Color)originalColor, (int)this.myTones), (int)originalColor.getAlpha());
            return filteredColor.getRGB();
        }
    }

    private static class DesaturationFilter
    extends RGBImageFilter {
        private DesaturationFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            Color originalColor = new Color(rgb, true);
            float[] rgba = originalColor.getRGBComponents(null);
            float min = Math.min((float)Math.min(originalColor.getRed(), originalColor.getGreen()), rgba[2]);
            float max = Math.max(Math.max(rgba[0], rgba[1]), rgba[2]);
            float grey = (max + min) / 2.0f;
            return new Color(grey, grey, grey, rgba[3]).getRGB();
        }
    }

    private static class ColorFilter
    implements Filter {
        private final float[] myBase;
        private final boolean myKeepGray;

        private ColorFilter(@NotNull Color color, boolean keepGray) {
            this.myKeepGray = keepGray;
            this.myBase = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        }

        @Override
        @NotNull
        public int[] convert(@NotNull int[] rgba) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(rgba[0], rgba[1], rgba[2], hsb);
            int rgb = Color.HSBtoRGB(this.myBase[0], this.myBase[1] * (this.myKeepGray ? hsb[1] : 1.0f), this.myBase[2] * hsb[2]);
            return new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, rgba[3]};
        }
    }

    @FunctionalInterface
    private static interface Filter {
        @NotNull
        public int[] convert(@NotNull int[] var1);
    }

    private static class CropIcon
    implements Icon {
        private final Icon mySrc;
        private final Rectangle myCrop;

        private CropIcon(@NotNull Icon src, @NotNull Rectangle crop) {
            this.mySrc = src;
            this.myCrop = crop;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.mySrc.paintIcon(c, g, x - this.myCrop.x, y - this.myCrop.y);
        }

        @Override
        public int getIconWidth() {
            return this.myCrop.width;
        }

        @Override
        public int getIconHeight() {
            return this.myCrop.height;
        }
    }

    public static class IconSizeWrapper
    implements Icon {
        private final Icon myIcon;
        private final int myWidth;
        private final int myHeight;

        protected IconSizeWrapper(@Nullable Icon icon, int width, int height) {
            this.myIcon = icon;
            this.myWidth = width;
            this.myHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintIcon(this.myIcon, c, g, x, y);
        }

        protected void paintIcon(@Nullable Icon icon, Component c, Graphics g, int x, int y) {
            if (icon == null) {
                return;
            }
            icon.paintIcon(c, g, x += (this.myWidth - icon.getIconWidth()) / 2, y += (this.myHeight - icon.getIconHeight()) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }
    }

    private static class FileIconPatcherHolder {
        private static final List<FileIconPatcher> ourPatchers = FileIconPatcher.EP_NAME.getExtensionList();

        private FileIconPatcherHolder() {
        }
    }

    private static class FileIconProviderHolder {
        private static final List<FileIconProvider> myProviders = FileIconProvider.EP_NAME.getExtensionList();

        private FileIconProviderHolder() {
        }
    }
}

