/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class InstanceofQuery<S, T>
implements Query<T> {
    private final Class<? extends T>[] myClasses;
    private final Query<S> myDelegate;

    public InstanceofQuery(Query<S> delegate, Class<? extends T> ... aClasses) {
        this.myClasses = aClasses;
        this.myDelegate = delegate;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList result2 = new ArrayList();
        this.forEach((Processor<? super T>)((Processor)o -> {
            result2.add(o);
            return true;
        }));
        return result2;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<? super T>)processor);
        return (T)processor.getFoundValue();
    }

    @Override
    public boolean forEach(@NotNull Processor<? super T> consumer) {
        return this.myDelegate.forEach(new MyProcessor(consumer));
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super T> consumer) {
        return this.myDelegate.forEachAsync(new MyProcessor(consumer));
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        Collection<T> all2 = this.findAll();
        return all2.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator(this.findAll().iterator());
    }

    private class MyProcessor
    implements Processor<S> {
        private final Processor<? super T> myConsumer;

        MyProcessor(Processor<? super T> consumer) {
            this.myConsumer = consumer;
        }

        public boolean process(S o) {
            for (Class aClass : InstanceofQuery.this.myClasses) {
                if (!aClass.isInstance(o)) continue;
                return this.myConsumer.process(o);
            }
            return true;
        }
    }
}

