/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.DefaultResultConsumer;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.concurrency.SameThreadExecutor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class MergeQuery<T>
implements Query<T> {
    private final Query<? extends T> myQuery1;
    private final Query<? extends T> myQuery2;

    public MergeQuery(@NotNull Query<? extends T> query1, @NotNull Query<? extends T> query2) {
        this.myQuery1 = query1;
        this.myQuery2 = query2;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList results = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(results);
        this.forEach((Processor<? super T>)processor);
        return results;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<? super T>)processor);
        return (T)processor.getFoundValue();
    }

    @Override
    public boolean forEach(@NotNull Processor<? super T> consumer) {
        return this.processSubQuery(this.myQuery1, consumer) && this.processSubQuery(this.myQuery2, consumer);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(final @NotNull Processor<? super T> consumer) {
        final AsyncFutureResult<Boolean> result2 = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        AsyncFuture<Boolean> fq = this.processSubQueryAsync(this.myQuery1, consumer);
        fq.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer<Boolean>)new DefaultResultConsumer<Boolean>(result2){

            @Override
            public void onSuccess(Boolean value) {
                if (value.booleanValue()) {
                    AsyncFuture fq2 = MergeQuery.this.processSubQueryAsync(MergeQuery.this.myQuery2, consumer);
                    fq2.addConsumer(SameThreadExecutor.INSTANCE, new DefaultResultConsumer(result2));
                } else {
                    result2.set(false);
                }
            }
        });
        return result2;
    }

    private <V extends T> boolean processSubQuery(@NotNull Query<V> subQuery, @NotNull Processor<? super T> consumer) {
        return subQuery.forEach(consumer);
    }

    private <V extends T> AsyncFuture<Boolean> processSubQueryAsync(@NotNull Query<V> query1, @NotNull Processor<? super T> consumer) {
        return query1.forEachAsync(consumer);
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        Collection<T> results = this.findAll();
        return results.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }
}

