/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UniqueResultsQuery<T, M>
implements Query<T> {
    @NotNull
    private final Query<? extends T> myOriginal;
    @NotNull
    private final TObjectHashingStrategy<? super M> myHashingStrategy;
    @NotNull
    private final Function<? super T, ? extends M> myMapper;

    public UniqueResultsQuery(@NotNull Query<? extends T> original) {
        this(original, ContainerUtil.canonicalStrategy(), Function.ID);
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull TObjectHashingStrategy<? super M> hashingStrategy) {
        this(original, hashingStrategy, Function.ID);
    }

    public UniqueResultsQuery(@NotNull Query<? extends T> original, @NotNull TObjectHashingStrategy<? super M> hashingStrategy, @NotNull Function<? super T, ? extends M> mapper) {
        this.myOriginal = original;
        this.myHashingStrategy = hashingStrategy;
        this.myMapper = mapper;
    }

    @Override
    public T findFirst() {
        return this.myOriginal.findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<? super T> consumer) {
        return this.process(Collections.synchronizedSet(new THashSet(this.myHashingStrategy)), consumer);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super T> consumer) {
        return this.processAsync(Collections.synchronizedSet(new THashSet(this.myHashingStrategy)), consumer);
    }

    private boolean process(@NotNull Set<? super M> processedElements, @NotNull Processor<? super T> consumer) {
        return this.myOriginal.forEach(new MyProcessor(processedElements, consumer));
    }

    @NotNull
    private AsyncFuture<Boolean> processAsync(@NotNull Set<? super M> processedElements, @NotNull Processor<? super T> consumer) {
        return this.myOriginal.forEachAsync(new MyProcessor(processedElements, consumer));
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor = Processors.cancelableCollectProcessor(result2);
        this.forEach((Processor<? super T>)processor);
        return result2;
    }

    @Override
    @NotNull
    public T[] toArray(@NotNull T[] a) {
        return this.findAll().toArray(a);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.findAll().iterator();
    }

    public String toString() {
        return "UniqueQuery: " + this.myOriginal;
    }

    private class MyProcessor
    implements Processor<T> {
        private final Set<? super M> myProcessedElements;
        private final Processor<? super T> myConsumer;

        MyProcessor(@NotNull Set<? super M> processedElements, Processor<? super T> consumer) {
            this.myProcessedElements = processedElements;
            this.myConsumer = consumer;
        }

        public boolean process(T t) {
            ProgressManager.checkCanceled();
            Object m = UniqueResultsQuery.this.myMapper.fun(t);
            if (this.myProcessedElements.contains(m)) {
                return true;
            }
            boolean result2 = this.myConsumer.process(t);
            this.myProcessedElements.add(m);
            return result2;
        }
    }
}

