/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class EdtExecutorServiceImpl
extends EdtExecutorService {
    static final EdtExecutorService INSTANCE = new EdtExecutorServiceImpl();

    private EdtExecutorServiceImpl() {
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            SwingUtilities.invokeLater(command);
        } else {
            this.execute(command, application.getAnyModalityState());
        }
    }

    @Override
    public void execute(@NotNull Runnable command, @NotNull ModalityState modalityState) {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            SwingUtilities.invokeLater(command);
        } else {
            application.invokeLater(command, modalityState);
        }
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable command, @NotNull ModalityState modalityState) {
        RunnableFuture<Object> future = this.newTaskFor(command, null);
        this.execute(future, modalityState);
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task, @NotNull ModalityState modalityState) {
        RunnableFuture<T> future = this.newTaskFor(task);
        this.execute(future, modalityState);
        return future;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return AppScheduledExecutorService.error();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        AppScheduledExecutorService.error();
        return false;
    }
}

