/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class QueueProcessor<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.concurrency.QueueProcessor");
    private final PairConsumer<? super T, ? super Runnable> myProcessor;
    private final Deque<T> myQueue = new ArrayDeque<T>();
    private boolean isProcessing;
    private boolean myStarted;
    private final ThreadToUse myThreadToUse;
    private final Condition<?> myDeathCondition;
    private final Map<Object, ModalityState> myModalityState = ContainerUtil.newIdentityTroveMap();

    public QueueProcessor(@NotNull Consumer<? super T> processor) {
        this(processor, Conditions.alwaysFalse());
    }

    public QueueProcessor(@NotNull Consumer<? super T> processor, @NotNull Condition<?> deathCondition) {
        this(processor, deathCondition, true);
    }

    public QueueProcessor(@NotNull Consumer<? super T> processor, @NotNull Condition<?> deathCondition, boolean autostart) {
        this(QueueProcessor.wrappingProcessor(processor), autostart, ThreadToUse.POOLED, deathCondition);
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor() {
        return new QueueProcessor<Runnable>(new RunnableConsumer());
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor(ThreadToUse threadToUse) {
        return new QueueProcessor<Runnable>(QueueProcessor.wrappingProcessor(new RunnableConsumer()), true, threadToUse, Conditions.FALSE);
    }

    @NotNull
    private static <T> PairConsumer<T, Runnable> wrappingProcessor(@NotNull Consumer<? super T> processor) {
        return (item, continuation) -> {
            try (SilentAutoClosable ignored = continuation::run;){
                QueueProcessor.runSafely(() -> processor.consume(item));
            }
        };
    }

    public QueueProcessor(@NotNull PairConsumer<? super T, ? super Runnable> processor, boolean autostart, @NotNull ThreadToUse threadToUse, @NotNull Condition<?> deathCondition) {
        this.myProcessor = processor;
        this.myStarted = autostart;
        this.myThreadToUse = threadToUse;
        this.myDeathCondition = deathCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            if (this.myStarted) {
                return;
            }
            this.myStarted = true;
            if (!this.myQueue.isEmpty()) {
                this.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcessing(boolean continueProcessing) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.isProcessing = false;
            if (this.myQueue.isEmpty()) {
                this.myQueue.notifyAll();
            } else if (continueProcessing) {
                this.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull T t, ModalityState state) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myModalityState.put(t, state);
        }
        this.doAdd(t, false);
    }

    public void add(@NotNull T element) {
        this.doAdd(element, false);
    }

    public void addFirst(@NotNull T element) {
        this.doAdd(element, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(@NotNull T element, boolean atHead) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            if (atHead) {
                this.myQueue.addFirst(element);
            } else {
                this.myQueue.add(element);
            }
            this.startProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            while (this.isProcessing) {
                try {
                    this.myQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitFor(long timeoutMS) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            long start = System.currentTimeMillis();
            while (this.isProcessing) {
                long rest = timeoutMS - (System.currentTimeMillis() - start);
                if (rest <= 0L) {
                    return !this.isProcessing;
                }
                try {
                    this.myQueue.wait(rest);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private boolean startProcessing() {
        LOG.assertTrue(Thread.holdsLock(this.myQueue));
        if (this.isProcessing || !this.myStarted) {
            return false;
        }
        this.isProcessing = true;
        T item = this.myQueue.removeFirst();
        Runnable runnable = () -> {
            if (this.myDeathCondition.value(null)) {
                this.finishProcessing(false);
                return;
            }
            QueueProcessor.runSafely(() -> this.myProcessor.consume(item, () -> this.finishProcessing(true)));
        };
        Application application = ApplicationManager.getApplication();
        if (this.myThreadToUse == ThreadToUse.AWT) {
            ModalityState state = this.myModalityState.remove(item);
            if (state != null) {
                application.invokeLater(runnable, state);
            } else {
                application.invokeLater(runnable);
            }
        } else {
            application.executeOnPooledThread(runnable);
        }
        return true;
    }

    public static void runSafely(@NotNull Runnable run) {
        try {
            run.run();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                LOG.error(e);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.isEmpty() && !this.isProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissLastTasks(int remaining) {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            while (this.myQueue.size() > remaining) {
                this.myQueue.pollLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingItemsToProcess() {
        Deque<T> deque = this.myQueue;
        synchronized (deque) {
            return !this.myQueue.isEmpty();
        }
    }

    public static final class RunnableConsumer
    implements Consumer<Runnable> {
        public void consume(Runnable runnable) {
            runnable.run();
        }
    }

    @FunctionalInterface
    protected static interface SilentAutoClosable
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static enum ThreadToUse {
        AWT,
        POOLED;

    }
}

