/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.IndexId;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final IntObjectMap<ID> ourRegistry = ContainerUtil.createConcurrentIntObjectMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private final short myUniqueId;

    @NotNull
    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        return new File(indexFolder, "indices.enum");
    }

    protected ID(@NotNull String name) {
        super(name);
        this.myUniqueId = ID.stringToId(name);
        ID old = (ID)((Object)ourRegistry.put((int)this.myUniqueId, (Object)this));
        assert (old == null) : "ID with name '" + name + "' is already registered";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short stringToId(@NotNull String name) {
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            if (ourNameToIdRegistry.containsKey((Object)name)) {
                return (short)ourNameToIdRegistry.get((Object)name);
            }
            int n = ourNameToIdRegistry.size() + 1;
            assert (n <= Short.MAX_VALUE) : "Number of indices exceeded: " + n;
            ourNameToIdRegistry.put((Object)name, n);
            ID.writeEnumFile();
            return (short)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reinitializeDiskStorage() {
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            ID.writeEnumFile();
        }
    }

    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            try (BufferedWriter w = new BufferedWriter(new FileWriter(f));){
                String[] names = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry((key, value) -> {
                    names[value - 1] = key;
                    return true;
                });
                for (String name : names) {
                    w.write(name);
                    w.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        ID<K, V> found = ID.findByName(name);
        return found == null ? new ID<K, V>(name) : found;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        return ID.findById(ID.stringToId(name));
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public static ID<?, ?> findById(int id) {
        return (ID)((Object)ourRegistry.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indices = ID.getEnumFile();
        try {
            TObjectIntHashMap nameToIdRegistry = new TObjectIntHashMap();
            try (BufferedReader reader = new BufferedReader(new FileReader(indices));){
                String name2;
                int cnt = 1;
                while ((name2 = reader.readLine()) != null) {
                    nameToIdRegistry.put((Object)name2, cnt);
                    ++cnt;
                }
            }
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.ensureCapacity(nameToIdRegistry.size());
                nameToIdRegistry.forEachEntry((name, index2) -> {
                    ourNameToIdRegistry.put(name, index2);
                    return true;
                });
            }
        }
        catch (IOException e) {
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.clear();
                ID.writeEnumFile();
            }
        }
    }
}

